$(document).ready(function () {
  var chart1 = null;
  var chart2 = null;
  var chart3 = null;
  var chart4 = null;
  var chart5 = null;

  $.ajax({
    url: '/chart-data',
    success: function (data) {
      renderChart(data);
    },
    error: function (error) {
      console.log(error);
    },
  });

  function renderChart(data) {
    // a line chart with ((vulnHigh+vulnCrit)/assets) for each date
    chart1 = new Chart($('#chart1'), {
      type: 'line',
      data: {
        labels: data.labels,
        datasets: data.chart_1_data,
      },
      options: {
        title: {
          display: true,
          text: '((vulnHigh+vulnCrit)/assets) for each date',
        },
      },
    });

    // a bar chart with high + critical for each ba for each date
    chart2 = new Chart($('#chart2'), {
      type: 'bar',
      data: {
        labels: data.labels,
        datasets: data.chart_2_data,
      },
      options: {
        scales: {
          y: {
            beginAtZero: true,
          },
        },
      },
    });

    // a bar chart with total assets for each ba for each date
    chart3 = new Chart($('#chart3'), {
      type: 'bar',
      data: {
        labels: data.labels,
        datasets: data.chart_3_data,
      },
    });

    // a line chart with # of obsoleteOS for each date
    chart4 = new Chart($('#chart4'), {
      type: 'line',
      data: {
        labels: data.labels,
        datasets: data.chart_4_data,
      },
    });
    // a line chart with # of worstassets for each date
    chart5 = new Chart($('#chart5'), {
      type: 'line',
      data: {
        labels: data.labels,
        datasets: data.chart_5_data,
      },
    });
  }

  // Destroy charts
  function clearCharts() {
    chart1.destroy();
    chart2.destroy();
    chart3.destroy();
    chart4.destroy();
    chart5.destroy();
  }

  // Handle filter
  $('#form').submit(function (e) {
    e.preventDefault();
    $.ajax({
      url: '/chart-data',
      data: $('#form').serialize(),
      success: function (data) {
        clearCharts();
        renderChart(data);
      },
      error: function (error) {
        console.log(error);
      },
    });
  });
});
