from django.views.generic import TemplateView, View
from django.http import JsonResponse
from datetime import datetime
import random
from .models import VulnData


class HomeView(TemplateView):
    template_name = 'index.html'


class ChartDataView(View):
    def get_color(self):
        r = random.randint(1, 256)
        g = random.randint(1, 256)
        b = random.randint(1, 256)
        return f'rgb({r}, {g}, {b})'

    def get(self, request, *args, **kwargs):
        queryset = VulnData.objects.all().order_by('-date')
        from_date = request.GET.get('from')
        to_date = request.GET.get('to')

        if from_date:
            from_date = datetime.strptime(from_date, "%Y-%m-%d")
            queryset = queryset.filter(date__gte=from_date)

        if to_date:
            to_date = datetime.strptime(to_date, "%Y-%m-%d")
            queryset = queryset.filter(date__lte=to_date)

        chart_1_data = []
        chart_2_data = []
        chart_3_data = []
        chart_4_data = []
        chart_5_data = []

        uniq_ba = queryset.order_by('ba').values_list(
            'ba', flat=True).distinct()

        for ba in uniq_ba:
            color = self.get_color()
            items = queryset.filter(ba=ba)
            labels = []
            temp_data = []
            temp_data2 = []
            temp_data3 = []
            temp_data4 = []
            temp_data5 = []

            for item in items:
                label = item.date
                labels.append(label)
                high_crit = item.highVuln + item.critVuln
                temp_data.append(high_crit / item.assets)
                temp_data2.append(high_crit)
                temp_data3.append(item.assets)
                temp_data4.append(item.obsoleteOS)
                temp_data5.append(item.worstassets)

            data = {
                'data': temp_data,
                'label': ba,
                'borderColor': color
            }
            data2 = {
                'data': temp_data2,
                'label': ba,
                'backgroundColor': color
            }
            data3 = {
                'data': temp_data3,
                'label': ba,
                'backgroundColor': color
            }
            data4 = {
                'data': temp_data4,
                'label': ba,
                'borderColor': color
            }
            data5 = {
                'data': temp_data5,
                'label': ba,
                'borderColor': color
            }
            chart_1_data.append(data)
            chart_2_data.append(data2)
            chart_3_data.append(data3)
            chart_4_data.append(data4)
            chart_5_data.append(data5)

        data = {
            "labels": labels,
            "chart_1_data": chart_1_data,
            "chart_2_data": chart_2_data,
            "chart_3_data": chart_3_data,
            "chart_4_data": chart_4_data,
            "chart_5_data": chart_5_data
        }
        return JsonResponse(data=data)
