$(document).ready(function () {
  $.ajax({
    url: '/chart-data',
    success: function (data) {
      renderChart(data);
    },
    error: function (error) {
      console.log(error);
    },
  });

  function renderChart(data) {
    // a line chart with ((vulnHigh+vulnCrit)/assets) for each date
    new Chart($('#chart1'), {
      type: 'line',
      data: {
        labels: data.labels,
        datasets: data.chart_1_data,
      },
      options: {
        title: {
          display: true,
          text: '((vulnHigh+vulnCrit)/assets) for each date',
        },
      },
    });

    // a bar chart with high + critical for each ba for each date
    new Chart($('#chart2'), {
      type: 'bar',
      data: {
        labels: data.labels,
        datasets: data.chart_2_data,
      },
      options: {
        scales: {
          y: {
            beginAtZero: true,
          },
        },
      },
    });

    // a bar chart with total assets for each ba for each date
    new Chart($('#chart3'), {
      type: 'bar',
      data: {
        labels: data.labels,
        datasets: data.chart_3_data,
      },
    });

    // a line chart with # of obsoleteOS for each date
    new Chart($('#chart4'), {
      type: 'line',
      data: {
        labels: data.labels,
        datasets: data.chart_4_data,
      },
    });
    // a line chart with # of worstassets for each date
    new Chart($('#chart5'), {
      type: 'line',
      data: {
        labels: data.labels,
        datasets: data.chart_5_data,
      },
    });
  }
});
