from django.views.generic import TemplateView, View
from django.http import JsonResponse
import random
from .models import VulnData


class HomeView(TemplateView):
    template_name = 'index.html'


class ChartDataView(View):
    def get(self, request, *args, **kwargs):
        queryset = VulnData.objects.all()
        colors = ['red', 'green', 'blue', 'teal', 'yellow', 'pink']

        chart_1_data = []
        chart_2_data = []
        chart_3_data = []
        chart_4_data = []
        chart_5_data = []

        uniq_ba = queryset.order_by('ba').values_list(
            'ba', flat=True).distinct()

        for ba in uniq_ba:
            items = queryset.filter(ba=ba)
            labels = []
            temp_data = []
            temp_data2 = []
            temp_data3 = []
            temp_data4 = []
            temp_data5 = []

            for item in items:
                label = item.date
                labels.append(label)
                high_crit = item.highVuln + item.critVuln
                temp_data.append(high_crit / item.assets)
                temp_data2.append(high_crit)
                temp_data3.append(item.assets)
                temp_data4.append(item.obsoleteOS)
                temp_data5.append(item.worstassets)

            data = {
                'data': temp_data,
                'label': ba,
                'borderColor': random.choice(colors)
            }
            data2 = {
                'data': temp_data2,
                'label': ba,
                'backgroundColor': random.choice(colors)
            }
            data3 = {
                'data': temp_data3,
                'label': ba,
                'backgroundColor': random.choice(colors)
            }
            data4 = {
                'data': temp_data4,
                'label': ba,
                'borderColor': random.choice(colors)
            }
            data5 = {
                'data': temp_data5,
                'label': ba,
                'borderColor': random.choice(colors)
            }
            chart_1_data.append(data)
            chart_2_data.append(data2)
            chart_3_data.append(data3)
            chart_4_data.append(data4)
            chart_5_data.append(data5)

        data = {
            "labels": labels,
            "chart_1_data": chart_1_data,
            "chart_2_data": chart_2_data,
            "chart_3_data": chart_3_data,
            "chart_4_data": chart_4_data,
            "chart_5_data": chart_5_data
        }
        return JsonResponse(data=data)
