-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local TexturePacks = TSM.UI:NewPackage("TexturePacks")
local private = {}
local TEXTURE_FILE_INFO = {
	uiFrames = {
		path = "Interface\\Addons\\TradeSkillMaster\\Media\\UIFrames.blp",
		scale = 1,
		width = 512,
		height = 512,
		coord = {
			["ActiveInputFieldLeft"] = { 94, 115, 211, 235 },
			["ActiveInputFieldMiddle"] = { 1, 22, 217, 241 },
			["ActiveInputFieldRight"] = { 1, 22, 245, 269 },
			["CraftingApplicationInnerFrameTopLeftCorner"] = { 1, 177, 1, 33 },
			["CraftingApplicationInnerFrameTopRightCorner"] = { 181, 357, 1, 33 },
			["DefaultUIButton"] = { 361, 492, 1, 17 },
			["DividerHandle"] = { 349, 357, 37, 119 },
			["HeaderLeft"] = { 319, 345, 37, 65 },
			["HeaderMiddle"] = { 319, 345, 69, 97 },
			["HeaderRight"] = { 319, 345, 101, 129 },
			["HighlightDot"] = { 349, 357, 123, 131 },
			["InactiveInputFieldLeft"] = { 43, 64, 243, 267 },
			["InactiveInputFieldMiddle"] = { 1, 22, 273, 297 },
			["InactiveInputFieldRight"] = { 243, 264, 135, 159 },
			["LargeActiveButtonLeft"] = { 31, 44, 187, 213 },
			["LargeActiveButtonMiddle"] = { 1, 27, 187, 213 },
			["LargeActiveButtonRight"] = { 26, 39, 217, 243 },
			["LargeApplicationCloseFrameBackground"] = { 64, 119, 121, 149 },
			["LargeApplicationFrameInnerFrameBottomEdge"] = { 360, 432, 141, 147 },
			["LargeApplicationFrameInnerFrameBottomLeftCorner"] = { 167, 193, 128, 154 },
			["LargeApplicationFrameInnerFrameBottomRightCorner"] = { 123, 149, 147, 173 },
			["LargeApplicationFrameInnerFrameLeftEdge"] = { 349, 356, 135, 207 },
			["LargeApplicationFrameInnerFrameRightEdge"] = { 349, 356, 211, 283 },
			["LargeApplicationInnerFrameTopEdge"] = { 167, 239, 95, 124 },
			["LargeApplicationInnerFrameTopLeftCorner"] = { 361, 433, 105, 137 },
			["LargeApplicationInnerFrameTopRightCorner"] = { 437, 509, 117, 149 },
			["LargeApplicationOuterFrameBottomEdge"] = { 243, 315, 95, 105 },
			["LargeApplicationOuterFrameBottomLeftCorner"] = { 252, 262, 195, 205 },
			["LargeApplicationOuterFrameBottomRightCorner"] = { 252, 262, 209, 219 },
			["LargeApplicationOuterFrameLeftEdge"] = { 50, 60, 137, 209 },
			["LargeApplicationOuterFrameRightEdge"] = { 153, 163, 147, 219 },
			["LargeApplicationOuterFrameTopEdge"] = { 167, 239, 37, 91 },
			["LargeApplicationOuterFrameTopLeftCorner"] = { 360, 424, 151, 205 },
			["LargeApplicationOuterFrameTopRightCorner"] = { 428, 492, 153, 207 },
			["LargeClickedButtonLeft"] = { 26, 39, 247, 273 },
			["LargeClickedButtonMiddle"] = { 197, 223, 128, 154 },
			["LargeClickedButtonRight"] = { 167, 180, 158, 184 },
			["LargeHoverButtonLeft"] = { 184, 197, 158, 184 },
			["LargeHoverButtonMiddle"] = { 64, 90, 153, 179 },
			["LargeHoverButtonRight"] = { 201, 214, 158, 184 },
			["LargeInactiveButtonLeft"] = { 218, 231, 160, 186 },
			["LargeInactiveButtonMiddle"] = { 64, 90, 183, 209 },
			["LargeInactiveButtonRight"] = { 235, 248, 163, 189 },
			["LoadingBarLeft"] = { 268, 288, 135, 174 },
			["LoadingBarMiddle"] = { 292, 312, 135, 174 },
			["LoadingBarRight"] = { 316, 336, 164, 203 },
			["MediumActiveButtonLeft"] = { 316, 329, 207, 227 },
			["MediumActiveButtonMiddle"] = { 496, 511, 1, 21 },
			["MediumActiveButtonRight"] = { 316, 329, 231, 251 },
			["MediumClickedButtonLeft"] = { 167, 180, 188, 208 },
			["MediumClickedButtonMiddle"] = { 495, 510, 25, 45 },
			["MediumClickedButtonRight"] = { 184, 197, 188, 208 },
			["MediumHoverButtonLeft"] = { 201, 214, 188, 208 },
			["MediumHoverButtonMiddle"] = { 495, 510, 49, 69 },
			["MediumHoverButtonRight"] = { 218, 231, 190, 210 },
			["MediumHoveredButtonLeft"] = { 235, 248, 193, 213 },
			["MediumHoveredButtonMiddle"] = { 495, 510, 49, 69 },
			["MediumHoveredButtonRight"] = { 266, 279, 208, 228 },
			["MediumInactiveButtonLeft"] = { 283, 296, 208, 228 },
			["MediumInactiveButtonMiddle"] = { 495, 510, 73, 93 },
			["MediumInactiveButtonRight"] = { 167, 180, 212, 232 },
			["PopupBottomEdge"] = { 227, 239, 128, 140 },
			["PopupBottomLeftCorner"] = { 78, 90, 213, 225 },
			["PopupBottomRightCorner"] = { 78, 90, 229, 241 },
			["PopupLeftEdge"] = { 227, 239, 144, 156 },
			["PopupRightEdge"] = { 252, 264, 163, 175 },
			["PopupTopEdge"] = { 252, 264, 179, 191 },
			["PopupTopLeftCorner"] = { 333, 345, 207, 219 },
			["PopupTopRightCorner"] = { 123, 163, 121, 143 },
			["PromoTextureLeft"] = { 361, 440, 21, 101 },
			["PromoTextureMiddle"] = { 1, 80, 37, 117 },
			["PromoTextureRight"] = { 84, 163, 37, 117 },
			["RankFrame"] = { 1, 46, 137, 151 },
			["RegularActiveDropdownLeft"] = { 268, 281, 178, 204 },
			["RegularActiveDropdownMiddle"] = { 122, 148, 177, 203 },
			["RegularActiveDropdownRight"] = { 285, 298, 178, 204 },
			["RegularInactiveDropdownLeft"] = { 492, 505, 232, 259 },
			["RegularInactiveDropdownMiddle"] = { 319, 345, 133, 160 },
			["RegularInactiveDropdownRight"] = { 492, 505, 263, 290 },
			["SearchLeft"] = { 184, 197, 212, 232 },
			["SearchMiddle"] = { 201, 214, 212, 232 },
			["SearchRight"] = { 218, 231, 214, 234 },
			["SearchTypeIndicator"] = { 1, 60, 121, 133 },
			["SmallActiveButtonLeft"] = { 235, 248, 217, 233 },
			["SmallActiveButtonMiddle"] = { 495, 510, 97, 113 },
			["SmallActiveButtonRight"] = { 266, 279, 232, 248 },
			["SmallApplicationCloseFrameBackground"] = { 1, 44, 155, 183 },
			["SmallApplicationInnerFrameBottomEdge"] = { 360, 432, 141, 147 },
			["SmallApplicationInnerFrameBottomLeftCorner"] = { 167, 193, 128, 154 },
			["SmallApplicationInnerFrameBottomRightCorner"] = { 123, 149, 147, 173 },
			["SmallApplicationInnerFrameLeftEdge"] = { 349, 356, 135, 207 },
			["SmallApplicationInnerFrameRightEdge"] = { 349, 356, 211, 283 },
			["SmallApplicationInnerFrameTopEdge"] = { 243, 315, 123, 131 },
			["SmallApplicationInnerFrameTopLeftCorner"] = { 122, 148, 207, 233 },
			["SmallApplicationInnerFrameTopRightCorner"] = { 48, 74, 213, 239 },
			["SmallApplicationOuterFrameBottomEdge"] = { 243, 315, 109, 119 },
			["SmallApplicationOuterFrameBottomLeftCorner"] = { 152, 162, 223, 233 },
			["SmallApplicationOuterFrameBottomRightCorner"] = { 252, 262, 223, 233 },
			["SmallApplicationOuterFrameLeftEdge"] = { 302, 312, 178, 250 },
			["SmallApplicationOuterFrameRightEdge"] = { 333, 343, 223, 295 },
			["SmallApplicationOuterFrameTopEdge"] = { 243, 315, 37, 91 },
			["SmallApplicationOuterFrameTopLeftCorner"] = { 360, 424, 209, 263 },
			["SmallApplicationOuterFrameTopRightCorner"] = { 94, 118, 153, 207 },
			["SmallClickedButtonLeft"] = { 283, 296, 232, 248 },
			["SmallClickedButtonMiddle"] = { 496, 511, 153, 169 },
			["SmallClickedButtonRight"] = { 235, 248, 237, 253 },
			["SmallHoverButtonLeft"] = { 166, 179, 236, 251 },
			["SmallHoverButtonMiddle"] = { 492, 507, 213, 228 },
			["SmallHoverButtonRight"] = { 183, 196, 236, 251 },
			["SmallHoveredButtonLeft"] = { 252, 265, 252, 268 },
			["SmallHoveredButtonMiddle"] = { 496, 511, 173, 189 },
			["SmallHoveredButtonRight"] = { 269, 282, 252, 268 },
			["SmallInactiveButtonLeft"] = { 286, 299, 254, 270 },
			["SmallInactiveButtonMiddle"] = { 496, 511, 193, 209 },
			["SmallInactiveButtonRight"] = { 303, 316, 255, 271 },
			["TSMLogo"] = { 428, 488, 211, 271 },
			["ToggleDisabledOff"] = { 444, 491, 21, 39 },
			["ToggleDisabledOn"] = { 444, 491, 43, 61 },
			["ToggleOff"] = { 444, 491, 65, 83 },
			["ToggleOn"] = { 444, 491, 87, 105 },
		},
	},
	iconPack = {
		path = "Interface\\Addons\\TradeSkillMaster\\Media\\IconPack.blp",
		scale = 2,
		width = 512,
		height = 1024,
		coord = {
			["10x10/Add/Circle"] = { 492, 512, 180, 200 },
			["10x10/Add/Default"] = { 492, 512, 200, 220 },
			["10x10/Arrow/Down"] = { 492, 512, 220, 240 },
			["10x10/Arrow/Up"] = { 492, 512, 240, 260 },
			["10x10/Auctions"] = { 492, 512, 260, 280 },
			["10x10/Bid"] = { 492, 512, 280, 300 },
			["10x10/Boxes"] = { 492, 512, 300, 320 },
			["10x10/Buyout"] = { 492, 512, 320, 340 },
			["10x10/Carot/Collapsed"] = { 196, 216, 288, 308 },
			["10x10/Carot/Expanded"] = { 196, 216, 308, 328 },
			["10x10/Checkmark/Circle"] = { 436, 456, 360, 380 },
			["10x10/Checkmark/Default"] = { 464, 484, 380, 400 },
			["10x10/Chevron/Collapsed"] = { 464, 484, 400, 420 },
			["10x10/Chevron/Expanded"] = { 196, 216, 328, 348 },
			["10x10/Chevron/Inactive"] = { 176, 196, 400, 420 },
			["10x10/Clock"] = { 176, 196, 420, 440 },
			["10x10/Close/Circle"] = { 176, 196, 440, 460 },
			["10x10/Close/Default"] = { 168, 188, 508, 528 },
			["10x10/Coins"] = { 48, 68, 520, 540 },
			["10x10/Configure"] = { 0, 20, 524, 544 },
			["10x10/Crafting"] = { 20, 40, 524, 544 },
			["10x10/Dashboard"] = { 68, 88, 520, 540 },
			["10x10/Delete"] = { 88, 108, 520, 540 },
			["10x10/DragHandle"] = { 108, 128, 520, 540 },
			["10x10/Duplicate"] = { 128, 148, 520, 540 },
			["10x10/Edit"] = { 148, 168, 520, 540 },
			["10x10/Groups"] = { 292, 312, 468, 488 },
			["10x10/Help"] = { 312, 332, 468, 488 },
			["10x10/Ignore"] = { 332, 352, 468, 488 },
			["10x10/Import"] = { 352, 372, 468, 488 },
			["10x10/Inventory"] = { 372, 392, 468, 488 },
			["10x10/Link"] = { 392, 412, 468, 488 },
			["10x10/More"] = { 292, 312, 488, 508 },
			["10x10/New"] = { 268, 288, 492, 512 },
			["10x10/Operations"] = { 240, 260, 504, 524 },
			["10x10/Pause"] = { 216, 236, 512, 532 },
			["10x10/Post"] = { 188, 208, 524, 544 },
			["10x10/Posting"] = { 168, 188, 528, 548 },
			["10x10/Queue"] = { 312, 332, 488, 508 },
			["10x10/Reset"] = { 332, 352, 488, 508 },
			["10x10/Resize"] = { 352, 372, 488, 508 },
			["10x10/Running"] = { 372, 392, 488, 508 },
			["10x10/SaleRate"] = { 392, 412, 488, 508 },
			["10x10/Search"] = { 412, 432, 488, 508 },
			["10x10/Settings"] = { 432, 452, 500, 520 },
			["10x10/Shopping"] = { 452, 472, 504, 524 },
			["10x10/SideArrow"] = { 472, 492, 504, 524 },
			["10x10/SkillUp"] = { 492, 512, 504, 524 },
			["10x10/SkillUp/1"] = { 40, 60, 540, 560 },
			["10x10/SkillUp/10"] = { 0, 20, 544, 564 },
			["10x10/SkillUp/2"] = { 20, 40, 544, 564 },
			["10x10/SkillUp/3"] = { 60, 80, 540, 560 },
			["10x10/SkillUp/4"] = { 80, 100, 540, 560 },
			["10x10/SkillUp/5"] = { 100, 120, 540, 560 },
			["10x10/SkillUp/6"] = { 120, 140, 540, 560 },
			["10x10/SkillUp/7"] = { 140, 160, 540, 560 },
			["10x10/SkillUp/8"] = { 288, 308, 508, 528 },
			["10x10/SkillUp/9"] = { 260, 280, 512, 532 },
			["10x10/Skip"] = { 236, 256, 524, 544 },
			["10x10/Sniper"] = { 208, 228, 532, 552 },
			["10x10/Star/Filled"] = { 188, 208, 544, 564 },
			["10x10/Star/Unfilled"] = { 160, 180, 548, 568 },
			["10x10/Stop"] = { 40, 60, 560, 580 },
			["10x10/Subtract/Circle"] = { 0, 20, 564, 584 },
			["10x10/Subtract/Default"] = { 20, 40, 564, 584 },
			["12x12/Add/Circle"] = { 216, 240, 180, 204 },
			["12x12/Add/Default"] = { 216, 240, 204, 228 },
			["12x12/Arrow/Down"] = { 216, 240, 228, 252 },
			["12x12/Arrow/Up"] = { 216, 240, 252, 276 },
			["12x12/Auctions"] = { 216, 240, 276, 300 },
			["12x12/Bid"] = { 216, 240, 300, 324 },
			["12x12/Boxes"] = { 216, 240, 324, 348 },
			["12x12/Buyout"] = { 56, 80, 400, 424 },
			["12x12/Carot/Collapsed"] = { 80, 104, 400, 424 },
			["12x12/Carot/Expanded"] = { 104, 128, 400, 424 },
			["12x12/Checkmark/Circle"] = { 128, 152, 400, 424 },
			["12x12/Checkmark/Default"] = { 152, 176, 400, 424 },
			["12x12/Chevron/Collapsed"] = { 196, 220, 404, 428 },
			["12x12/Chevron/Expanded"] = { 220, 244, 416, 440 },
			["12x12/Chevron/Inactive"] = { 196, 220, 428, 452 },
			["12x12/Clock"] = { 244, 268, 432, 456 },
			["12x12/Close/Circle"] = { 220, 244, 440, 464 },
			["12x12/Close/Default"] = { 56, 80, 424, 448 },
			["12x12/Coins"] = { 0, 24, 428, 452 },
			["12x12/Configure"] = { 24, 48, 428, 452 },
			["12x12/Crafting"] = { 80, 104, 424, 448 },
			["12x12/Dashboard"] = { 104, 128, 424, 448 },
			["12x12/Delete"] = { 128, 152, 424, 448 },
			["12x12/DragHandle"] = { 152, 176, 424, 448 },
			["12x12/Duplicate"] = { 196, 220, 452, 476 },
			["12x12/Edit"] = { 48, 72, 448, 472 },
			["12x12/Groups"] = { 0, 24, 452, 476 },
			["12x12/Help"] = { 24, 48, 452, 476 },
			["12x12/Ignore"] = { 72, 96, 448, 472 },
			["12x12/Import"] = { 96, 120, 448, 472 },
			["12x12/Inventory"] = { 120, 144, 448, 472 },
			["12x12/Link"] = { 144, 168, 448, 472 },
			["12x12/More"] = { 168, 192, 460, 484 },
			["12x12/New"] = { 48, 72, 472, 496 },
			["12x12/Operations"] = { 0, 24, 476, 500 },
			["12x12/Pause"] = { 24, 48, 476, 500 },
			["12x12/Post"] = { 72, 96, 472, 496 },
			["12x12/Posting"] = { 96, 120, 472, 496 },
			["12x12/Queue"] = { 120, 144, 472, 496 },
			["12x12/Reset"] = { 144, 168, 472, 496 },
			["12x12/Resize"] = { 268, 292, 444, 468 },
			["12x12/Running"] = { 244, 268, 456, 480 },
			["12x12/SaleRate"] = { 220, 244, 464, 488 },
			["12x12/Search"] = { 192, 216, 476, 500 },
			["12x12/Settings"] = { 168, 192, 484, 508 },
			["12x12/Shopping"] = { 48, 72, 496, 520 },
			["12x12/SideArrow"] = { 0, 24, 500, 524 },
			["12x12/SkillUp"] = { 24, 48, 500, 524 },
			["12x12/SkillUp/1"] = { 72, 96, 496, 520 },
			["12x12/SkillUp/10"] = { 96, 120, 496, 520 },
			["12x12/SkillUp/2"] = { 120, 144, 496, 520 },
			["12x12/SkillUp/3"] = { 144, 168, 496, 520 },
			["12x12/SkillUp/4"] = { 292, 316, 444, 468 },
			["12x12/SkillUp/5"] = { 316, 340, 444, 468 },
			["12x12/SkillUp/6"] = { 340, 364, 444, 468 },
			["12x12/SkillUp/7"] = { 364, 388, 444, 468 },
			["12x12/SkillUp/8"] = { 388, 412, 444, 468 },
			["12x12/SkillUp/9"] = { 412, 436, 464, 488 },
			["12x12/Skip"] = { 436, 460, 476, 500 },
			["12x12/Sniper"] = { 460, 484, 480, 504 },
			["12x12/Star/Filled"] = { 484, 508, 480, 504 },
			["12x12/Star/Unfilled"] = { 268, 292, 468, 492 },
			["12x12/Stop"] = { 244, 268, 480, 504 },
			["12x12/Subtract/Circle"] = { 216, 240, 488, 512 },
			["12x12/Subtract/Default"] = { 192, 216, 500, 524 },
			["14x14/Add/Circle"] = { 456, 484, 324, 352 },
			["14x14/Add/Default"] = { 484, 512, 340, 368 },
			["14x14/Arrow/Down"] = { 456, 484, 352, 380 },
			["14x14/Arrow/Up"] = { 484, 512, 368, 396 },
			["14x14/Auctions"] = { 0, 28, 288, 316 },
			["14x14/Bid"] = { 28, 56, 288, 316 },
			["14x14/Boxes"] = { 56, 84, 288, 316 },
			["14x14/Buyout"] = { 84, 112, 288, 316 },
			["14x14/Carot/Collapsed"] = { 112, 140, 288, 316 },
			["14x14/Carot/Expanded"] = { 140, 168, 288, 316 },
			["14x14/Checkmark/Circle"] = { 168, 196, 288, 316 },
			["14x14/Checkmark/Default"] = { 240, 268, 332, 360 },
			["14x14/Chevron/Collapsed"] = { 268, 296, 348, 376 },
			["14x14/Chevron/Expanded"] = { 296, 324, 360, 388 },
			["14x14/Chevron/Inactive"] = { 324, 352, 360, 388 },
			["14x14/Clock"] = { 352, 380, 360, 388 },
			["14x14/Close/Circle"] = { 380, 408, 360, 388 },
			["14x14/Close/Default"] = { 408, 436, 360, 388 },
			["14x14/Coins"] = { 436, 464, 380, 408 },
			["14x14/Configure"] = { 484, 512, 396, 424 },
			["14x14/Crafting"] = { 0, 28, 316, 344 },
			["14x14/Dashboard"] = { 28, 56, 316, 344 },
			["14x14/Delete"] = { 56, 84, 316, 344 },
			["14x14/DragHandle"] = { 84, 112, 316, 344 },
			["14x14/Duplicate"] = { 112, 140, 316, 344 },
			["14x14/Edit"] = { 140, 168, 316, 344 },
			["14x14/Groups"] = { 168, 196, 316, 344 },
			["14x14/Help"] = { 0, 28, 344, 372 },
			["14x14/Ignore"] = { 28, 56, 344, 372 },
			["14x14/Import"] = { 56, 84, 344, 372 },
			["14x14/Inventory"] = { 84, 112, 344, 372 },
			["14x14/Link"] = { 112, 140, 344, 372 },
			["14x14/More"] = { 140, 168, 344, 372 },
			["14x14/New"] = { 168, 196, 344, 372 },
			["14x14/Operations"] = { 196, 224, 348, 376 },
			["14x14/Pause"] = { 224, 252, 360, 388 },
			["14x14/Post"] = { 252, 280, 376, 404 },
			["14x14/Posting"] = { 280, 308, 388, 416 },
			["14x14/Queue"] = { 308, 336, 388, 416 },
			["14x14/Reset"] = { 336, 364, 388, 416 },
			["14x14/Resize"] = { 364, 392, 388, 416 },
			["14x14/Running"] = { 392, 420, 388, 416 },
			["14x14/SaleRate"] = { 420, 448, 408, 436 },
			["14x14/Search"] = { 448, 476, 420, 448 },
			["14x14/Settings"] = { 476, 504, 424, 452 },
			["14x14/Shopping"] = { 0, 28, 372, 400 },
			["14x14/SideArrow"] = { 28, 56, 372, 400 },
			["14x14/SkillUp"] = { 56, 84, 372, 400 },
			["14x14/SkillUp/1"] = { 84, 112, 372, 400 },
			["14x14/SkillUp/10"] = { 112, 140, 372, 400 },
			["14x14/SkillUp/2"] = { 140, 168, 372, 400 },
			["14x14/SkillUp/3"] = { 168, 196, 372, 400 },
			["14x14/SkillUp/4"] = { 196, 224, 376, 404 },
			["14x14/SkillUp/5"] = { 224, 252, 388, 416 },
			["14x14/SkillUp/6"] = { 252, 280, 404, 432 },
			["14x14/SkillUp/7"] = { 280, 308, 416, 444 },
			["14x14/SkillUp/8"] = { 308, 336, 416, 444 },
			["14x14/SkillUp/9"] = { 336, 364, 416, 444 },
			["14x14/Skip"] = { 364, 392, 416, 444 },
			["14x14/Sniper"] = { 392, 420, 416, 444 },
			["14x14/Star/Filled"] = { 420, 448, 436, 464 },
			["14x14/Star/Unfilled"] = { 448, 476, 448, 476 },
			["14x14/Stop"] = { 476, 504, 452, 480 },
			["14x14/Subtract/Circle"] = { 0, 28, 400, 428 },
			["14x14/Subtract/Default"] = { 28, 56, 400, 428 },
			["18x18/Add/Circle"] = { 472, 508, 0, 36 },
			["18x18/Add/Default"] = { 472, 508, 36, 72 },
			["18x18/Arrow/Down"] = { 336, 372, 36, 72 },
			["18x18/Arrow/Up"] = { 336, 372, 72, 108 },
			["18x18/Auctions"] = { 468, 504, 72, 108 },
			["18x18/Bid"] = { 468, 504, 108, 144 },
			["18x18/Boxes"] = { 336, 372, 108, 144 },
			["18x18/Buyout"] = { 288, 324, 132, 168 },
			["18x18/Carot/Collapsed"] = { 240, 276, 152, 188 },
			["18x18/Carot/Expanded"] = { 324, 360, 144, 180 },
			["18x18/Checkmark/Circle"] = { 276, 312, 168, 204 },
			["18x18/Checkmark/Default"] = { 360, 396, 144, 180 },
			["18x18/Chevron/Collapsed"] = { 396, 432, 144, 180 },
			["18x18/Chevron/Expanded"] = { 432, 468, 144, 180 },
			["18x18/Chevron/Inactive"] = { 468, 504, 144, 180 },
			["18x18/Clock"] = { 312, 348, 180, 216 },
			["18x18/Close/Circle"] = { 348, 384, 180, 216 },
			["18x18/Close/Default"] = { 384, 420, 180, 216 },
			["18x18/Coins"] = { 420, 456, 180, 216 },
			["18x18/Configure"] = { 456, 492, 180, 216 },
			["18x18/Crafting"] = { 0, 36, 180, 216 },
			["18x18/Dashboard"] = { 36, 72, 180, 216 },
			["18x18/Delete"] = { 72, 108, 180, 216 },
			["18x18/DragHandle"] = { 108, 144, 180, 216 },
			["18x18/Duplicate"] = { 144, 180, 180, 216 },
			["18x18/Edit"] = { 180, 216, 180, 216 },
			["18x18/Groups"] = { 240, 276, 188, 224 },
			["18x18/Help"] = { 276, 312, 204, 240 },
			["18x18/Ignore"] = { 240, 276, 224, 260 },
			["18x18/Import"] = { 312, 348, 216, 252 },
			["18x18/Inventory"] = { 276, 312, 240, 276 },
			["18x18/Link"] = { 348, 384, 216, 252 },
			["18x18/More"] = { 384, 420, 216, 252 },
			["18x18/New"] = { 420, 456, 216, 252 },
			["18x18/Operations"] = { 456, 492, 216, 252 },
			["18x18/Pause"] = { 312, 348, 252, 288 },
			["18x18/Post"] = { 348, 384, 252, 288 },
			["18x18/Posting"] = { 384, 420, 252, 288 },
			["18x18/Queue"] = { 420, 456, 252, 288 },
			["18x18/Reset"] = { 456, 492, 252, 288 },
			["18x18/Resize"] = { 0, 36, 216, 252 },
			["18x18/Running"] = { 36, 72, 216, 252 },
			["18x18/SaleRate"] = { 72, 108, 216, 252 },
			["18x18/Search"] = { 108, 144, 216, 252 },
			["18x18/Settings"] = { 144, 180, 216, 252 },
			["18x18/Shopping"] = { 180, 216, 216, 252 },
			["18x18/SideArrow"] = { 0, 36, 252, 288 },
			["18x18/SkillUp"] = { 36, 72, 252, 288 },
			["18x18/SkillUp/1"] = { 72, 108, 252, 288 },
			["18x18/SkillUp/10"] = { 108, 144, 252, 288 },
			["18x18/SkillUp/2"] = { 144, 180, 252, 288 },
			["18x18/SkillUp/3"] = { 180, 216, 252, 288 },
			["18x18/SkillUp/4"] = { 240, 276, 260, 296 },
			["18x18/SkillUp/5"] = { 276, 312, 276, 312 },
			["18x18/SkillUp/6"] = { 240, 276, 296, 332 },
			["18x18/SkillUp/7"] = { 312, 348, 288, 324 },
			["18x18/SkillUp/8"] = { 276, 312, 312, 348 },
			["18x18/SkillUp/9"] = { 348, 384, 288, 324 },
			["18x18/Skip"] = { 384, 420, 288, 324 },
			["18x18/Sniper"] = { 420, 456, 288, 324 },
			["18x18/Star/Filled"] = { 456, 492, 288, 324 },
			["18x18/Star/Unfilled"] = { 312, 348, 324, 360 },
			["18x18/Stop"] = { 348, 384, 324, 360 },
			["18x18/Subtract/Circle"] = { 384, 420, 324, 360 },
			["18x18/Subtract/Default"] = { 420, 456, 324, 360 },
			["24x24/Auctions"] = { 376, 424, 0, 48 },
			["24x24/Bid"] = { 424, 472, 0, 48 },
			["24x24/Boxes"] = { 0, 48, 36, 84 },
			["24x24/Buyout"] = { 48, 96, 36, 84 },
			["24x24/Close/Circle"] = { 96, 144, 36, 84 },
			["24x24/Close/Default"] = { 144, 192, 36, 84 },
			["24x24/Coins"] = { 192, 240, 36, 84 },
			["24x24/Crafting"] = { 240, 288, 36, 84 },
			["24x24/Dashboard"] = { 288, 336, 36, 84 },
			["24x24/Groups"] = { 372, 420, 48, 96 },
			["24x24/Import"] = { 420, 468, 48, 96 },
			["24x24/Inventory"] = { 372, 420, 96, 144 },
			["24x24/Operations"] = { 420, 468, 96, 144 },
			["24x24/Pause"] = { 0, 48, 84, 132 },
			["24x24/Post"] = { 48, 96, 84, 132 },
			["24x24/Posting"] = { 96, 144, 84, 132 },
			["24x24/Settings"] = { 144, 192, 84, 132 },
			["24x24/Shopping"] = { 192, 240, 84, 132 },
			["24x24/Skip"] = { 240, 288, 84, 132 },
			["24x24/Sniper"] = { 288, 336, 84, 132 },
			["24x24/Stop"] = { 0, 48, 132, 180 },
			["Misc/BackArrow"] = { 240, 288, 132, 152 },
			["Misc/Checkbox/Checked"] = { 48, 96, 132, 180 },
			["Misc/Checkbox/Checked/Disabled"] = { 96, 144, 132, 180 },
			["Misc/Checkbox/Unchecked"] = { 144, 192, 132, 180 },
			["Misc/Checkbox/Unchecked/Disabled"] = { 192, 240, 132, 180 },
			["Misc/Toggle/Off"] = { 0, 94, 0, 36 },
			["Misc/Toggle/Off/Disabled"] = { 94, 188, 0, 36 },
			["Misc/Toggle/On"] = { 188, 282, 0, 36 },
			["Misc/Toggle/On/Disabled"] = { 282, 376, 0, 36 },
		},
	},
}



-- ============================================================================
-- Module Functions
-- ============================================================================

function TexturePacks.IsValid(key)
	-- if not key then return false end
	local fileInfo, coord = private.GetFileInfo(key)
	return fileInfo and coord and true or false
end

function TexturePacks.GetTexturePath(key)
	local fileInfo = private.GetFileInfo(key)
	assert(fileInfo)
	return fileInfo.path
end

function TexturePacks.GetTexCoord(key)
	local fileInfo, coord = private.GetFileInfo(key)
	assert(fileInfo and coord)
	local minX, maxX, minY, maxY = unpack(coord)
	minX = minX / fileInfo.width
	maxX = maxX / fileInfo.width
	minY = minY / fileInfo.height
	maxY = maxY / fileInfo.height
	return minX, maxX, minY, maxY
end

function TexturePacks.GetTexCoordRotated(key, angle)
	return private.RotateTexCoords(angle, TexturePacks.GetTexCoord(key))
end

function TexturePacks.GetSize(key)
	local fileInfo, coord = private.GetFileInfo(key)
	assert(fileInfo and coord)
	local minX, maxX, minY, maxY = unpack(coord)
	local width = (maxX - minX) / fileInfo.scale
	local height = (maxY - minY) / fileInfo.scale
	return width, height
end

function TexturePacks.GetWidth(key)
	local width = TexturePacks.GetSize(key)
	return width
end

function TexturePacks.GetHeight(key)
	local _, height = TexturePacks.GetSize(key)
	return height
end

function TexturePacks.SetTexture(texture, key)
	texture:SetTexture(TexturePacks.GetTexturePath(key))
	texture:SetTexCoord(TexturePacks.GetTexCoord(key))
end

function TexturePacks.SetTextureRotated(texture, key, angle)
	texture:SetTexture(TexturePacks.GetTexturePath(key))
	texture:SetTexCoord(TexturePacks.GetTexCoordRotated(key, angle))
end

function TexturePacks.SetSize(texture, key)
	local width, height = TexturePacks.GetSize(key)
	texture:SetWidth(width)
	texture:SetHeight(height)
end

function TexturePacks.SetWidth(texture, key)
	texture:SetWidth(TexturePacks.GetWidth(key))
end

function TexturePacks.SetHeight(texture, key)
	texture:SetHeight(TexturePacks.GetHeight(key))
end

function TexturePacks.SetTextureAndWidth(texture, key)
	TexturePacks.SetTexture(texture, key)
	TexturePacks.SetWidth(texture, key)
end

function TexturePacks.SetTextureAndHeight(texture, key)
	TexturePacks.SetTexture(texture, key)
	TexturePacks.SetHeight(texture, key)
end

function TexturePacks.SetTextureAndSize(texture, key)
	TexturePacks.SetTexture(texture, key)
	TexturePacks.SetSize(texture, key)
end

function TexturePacks.SetTextureAndSizeRotated(texture, key, angle)
	TexturePacks.SetTextureRotated(texture, key, angle)
	TexturePacks.SetSize(texture, key)
end



-- ============================================================================
-- Private Helper Functions
-- ============================================================================

function private.GetFileInfo(key)
	local file, entry = strmatch(key, "^([^%.]+)%.(.+)$")
	local fileInfo = file and TEXTURE_FILE_INFO[file]
	return fileInfo, fileInfo and fileInfo.coord[entry]
end

function private.RotateTexCoords(angle, minX, maxX, minY, maxY)
	local centerX = (minX + maxX) / 2
	local centerY = (minY + maxY) / 2
	local ULx, ULy = private.RotateCoordPair(minX, minY, centerX, centerY, angle)
	local LLx, LLy = private.RotateCoordPair(minX, maxY, centerX, centerY, angle)
	local URx, URy = private.RotateCoordPair(maxX, minY, centerX, centerY, angle)
	local LRx, LRy = private.RotateCoordPair(maxX, maxY, centerX, centerY, angle)
	return ULx, ULy, LLx, LLy, URx, URy, LRx, LRy
end

function private.RotateCoordPair(x, y, originX, originY, angle)
	local cosResult = cos(angle)
	local sinResult = sin(angle)
	local resultX = originX + (x - originX) * cosResult - (y - originY) * sinResult
	local resultY = originY + (y - originY) * cosResult + (x - originX) * sinResult
	return resultX, resultY
end
