-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local Vendoring = TSM.MainUI.Settings:NewPackage("Vendoring")
local L = LibStub("AceLocale-3.0"):GetLocale("TradeSkillMaster") -- loads the localization table
local private = {}
local DEFAULT_PAGE = { L["Buy"], L["Buyback"], L["TSM Groups"], L["Quick Sell"] }


-- ============================================================================
-- Module Functions
-- ============================================================================

function Vendoring.OnInitialize()
	TSM.MainUI.Settings.RegisterSettingPage("Vendoring", "middle", private.GetVendoringSettingsFrame)
end



-- ============================================================================
-- Vendoring Settings UI
-- ============================================================================

function private.GetVendoringSettingsFrame()
	return TSMAPI_FOUR.UI.NewElement("ScrollFrame", "vendoringSettings")
		:SetStyle("padding", 10)
		:AddChild(TSM.MainUI.Settings.CreateHeadingLine("generalOptionsTitle", L["General Options"]))
		:AddChild(TSM.MainUI.Settings.CreateSettingLine("defaultVendoringPageLine", L["Default vendoring page:"])
			:AddChild(TSMAPI_FOUR.UI.NewElement("Dropdown", "defaultVendoringPageDropdown")
				:SetItems(DEFAULT_PAGE, DEFAULT_PAGE[TSM.db.global.vendoringOptions.defaultPage])
				:SetSettingInfo(TSM.db.global.vendoringOptions, "defaultPage")
			)
		)
		:AddChild(TSM.MainUI.Settings.CreateSettingLine("defaultMerchantTabFrame", L["Make vendoring default merchant tab?"])
			:AddChild(TSMAPI_FOUR.UI.NewElement("Toggle", "defaultMerchantTabToggle")
				:SetStyle("width", 80)
				:SetStyle("height", 20)
				:SetBooleanToggle(TSM.db.global.vendoringOptions, "defaultMerchantTab")
			)
		)
		:AddChild(TSM.MainUI.Settings.CreateSettingLine("autoSellTrashFrame", L["Automatically sell vendor trash?"])
			:AddChild(TSMAPI_FOUR.UI.NewElement("Toggle", "autoSellTrashToggle")
				:SetStyle("width", 80)
				:SetStyle("height", 20)
				:SetBooleanToggle(TSM.db.global.vendoringOptions, "autoSellTrash")
			)
		)
		:AddChild(TSM.MainUI.Settings.CreateSettingLine("displayMoneyCollectedFrame", L["Display total money recieved in chat?"])
			:AddChild(TSMAPI_FOUR.UI.NewElement("Toggle", "displayMoneyCollectedToggle")
				:SetStyle("width", 80)
				:SetStyle("height", 20)
				:SetBooleanToggle(TSM.db.global.vendoringOptions, "displayMoneyCollected")
			)
		)
		:AddChild(TSM.MainUI.Settings.CreateHeadingLine("generalOptionsTitle", L["Quick Sell Options"]))
		:AddChild(TSM.MainUI.Settings.CreateSettingLine("qsBatchSizeFrame", L["Batch size:"])
			:AddChild(TSMAPI_FOUR.UI.NewElement("InputNumeric", "qsBatchSizeInput")
				:SetStyle("background", "#1ae2e2e2")
				:SetStyle("margin", { right = 10 })
				:SetStyle("justifyH", "CENTER")
				:SetStyle("width", 75)
				:SetSettingInfo(TSM.db.global.vendoringOptions, "qsBatchSize")
				:SetMaxNumber(100)
			)
			:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "qsBatchSizeLabel")
				:SetStyle("fontHeight", 18)
				:SetText(L["(minimum 1 - maximum 100)"])
			)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "qsMarketValueText")
			:SetLayout("HORIZONTAL")
			:SetStyle("height", 29)
			:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "label")
				:SetStyle("textColor", "#e2e2e2")
				:SetStyle("fontHeight", 18)
				:SetStyle("justifyV", "LEFT")
				:SetText(L["Market Value Price Source:"])
			)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "qsMarketValueFrame")
			:SetLayout("HORIZONTAL")
			:SetStyle("height", 29)
			:SetStyle("margin", { bottom = 20 })
			:AddChild(TSMAPI_FOUR.UI.NewElement("Input", "qsMarketValueInput")
				:SetStyle("background", "#1ae2e2e2")
				:SetStyle("height", 29)
				:SetStyle("justifyH", "LEFT")
				:SetSettingInfo(TSM.db.global.vendoringOptions, "qsMarketValue", private.CheckCustomPrice)
			)
			:AddChild(TSMAPI_FOUR.UI.NewElement("Button", "qsMarketValueResetButton")
				:SetStyle("borderTexture", "Interface\\Addons\\TradeSkillMaster\\Media\\ButtonEdgeFrame.blp")
				:SetStyle("borderSize", 7)
				:SetStyle("margin", { left = 20 })
				:SetStyle("width", 120)
				:SetStyle("height", 29)
				:SetText(RESET)
				:SetScript("OnClick", private.ResetMVSource)
			)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "qsMaxMarketValueText")
			:SetLayout("HORIZONTAL")
			:SetStyle("height", 29)
			:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "label")
				:SetStyle("textColor", "#e2e2e2")
				:SetStyle("fontHeight", 18)
				:SetStyle("justifyV", "LEFT")
				:SetText(L["Max Market Value:"])
			)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "qsMaxMarketValueFrame")
			:SetLayout("HORIZONTAL")
			:SetStyle("height", 29)
			:SetStyle("margin", { bottom = 20 })
			:AddChild(TSMAPI_FOUR.UI.NewElement("Input", "qsMaxMarketValueInput")
				:SetStyle("background", "#1ae2e2e2")
				:SetStyle("height", 29)
				:SetStyle("justifyH", "LEFT")
				:SetSettingInfo(TSM.db.global.vendoringOptions, "qsMaxMarketValue", private.CheckCustomPrice)
			)
			:AddChild(TSMAPI_FOUR.UI.NewElement("Button", "qsMaxMarketValueResetButton")
				:SetStyle("borderTexture", "Interface\\Addons\\TradeSkillMaster\\Media\\ButtonEdgeFrame.blp")
				:SetStyle("borderSize", 7)
				:SetStyle("margin", { left = 20 })
				:SetStyle("width", 120)
				:SetStyle("height", 29)
				:SetText(RESET)
				:SetScript("OnClick", private.ResetMaxMVSource)
			)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "qsDestroyValueText")
			:SetLayout("HORIZONTAL")
			:SetStyle("height", 29)
			:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "label")
				:SetStyle("textColor", "#e2e2e2")
				:SetStyle("fontHeight", 18)
				:SetStyle("justifyV", "LEFT")
				:SetText(L["Destroy Value:"])
			)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "qsDestroyValueFrame")
			:SetLayout("HORIZONTAL")
			:SetStyle("height", 29)
			:SetStyle("margin", { bottom = 20 })
			:AddChild(TSMAPI_FOUR.UI.NewElement("Input", "qsDestroyValueInput")
				:SetStyle("background", "#1ae2e2e2")
				:SetStyle("height", 29)
				:SetStyle("justifyH", "LEFT")
				:SetSettingInfo(TSM.db.global.vendoringOptions, "qsDestroyValue", private.CheckCustomPrice)
			)
			:AddChild(TSMAPI_FOUR.UI.NewElement("Button", "qsDestroyValueResetButton")
				:SetStyle("borderTexture", "Interface\\Addons\\TradeSkillMaster\\Media\\ButtonEdgeFrame.blp")
				:SetStyle("borderSize", 7)
				:SetStyle("margin", { left = 20 })
				:SetStyle("width", 120)
				:SetStyle("height", 29)
				:SetText(RESET)
				:SetScript("OnClick", private.ResetDestroyValue)
			)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "qsMaxDestroyValueText")
			:SetLayout("HORIZONTAL")
			:SetStyle("height", 26)
			:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "label")
				:SetStyle("textColor", "#e2e2e2")
				:SetStyle("fontHeight", 18)
				:SetStyle("justifyV", "LEFT")
				:SetText(L["Max Destory Value:"])
			)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "qsMaxDestroyValueFrame")
			:SetLayout("HORIZONTAL")
			:SetStyle("height", 29)
			:SetStyle("margin", { bottom = 20 })
			:AddChild(TSMAPI_FOUR.UI.NewElement("Input", "qsMaxDestroyValueInput")
				:SetStyle("background", "#1ae2e2e2")
				:SetStyle("height", 29)
				:SetStyle("justifyH", "LEFT")
				:SetSettingInfo(TSM.db.global.vendoringOptions, "qsMaxDestroyValue", private.CheckCustomPrice)
			)
			:AddChild(TSMAPI_FOUR.UI.NewElement("Button", "qsMaxDestroyValueResetButton")
				:SetStyle("borderTexture", "Interface\\Addons\\TradeSkillMaster\\Media\\ButtonEdgeFrame.blp")
				:SetStyle("borderSize", 7)
				:SetStyle("margin", { left = 20 })
				:SetStyle("width", 120)
				:SetStyle("height", 29)
				:SetText(RESET)
				:SetScript("OnClick", private.ResetMaxDestroyValue)
			)
		)
end



-- ============================================================================
-- Local Script Handlers
-- ============================================================================

function private.CheckCustomPrice(value)
	if TSMAPI_FOUR.CustomPrice.Validate(value) then
		return true
	else
		-- TODO: better error message
		TSM:Print("Your custom price was incorrect. Please try again.")
		return false
	end
end

function private.ResetMVSource(self)
	TSM.db.global.vendoringOptions.qsMarketValue = "dbmarket"
	local input = self:GetElement("__parent.qsMarketValueInput")
	input:SetText(TSM.db.global.vendoringOptions.qsMarketValue)
	input:Draw()
end

function private.ResetMaxMVSource(self)
	TSM.db.global.vendoringOptions.qsMaxMarketValue = "100g"
	local input = self:GetElement("__parent.qsMaxMarketValueInput")
	input:SetText(TSM.db.global.vendoringOptions.qsMaxMarketValue)
	input:Draw()
end

function private.ResetDestroyValue(self)
	TSM.db.global.vendoringOptions.qsDestroyValue = "destroy"
	local input = self:GetElement("__parent.qsDestroyValueInput")
	input:SetText(TSM.db.global.vendoringOptions.qsDestroyValue)
	input:Draw()
end

function private.ResetMaxDestroyValue(self)
	TSM.db.global.vendoringOptions.qsMaxDestroyValue = "100g"
	local input = self:GetElement("__parent.qsMaxDestroyValueInput")
	input:SetText(TSM.db.global.vendoringOptions.qsMaxDestroyValue)
	input:Draw()
end
