-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local ValueSources = TSM.MainUI.Settings.Tooltip:NewPackage("ValueSources")
local L = LibStub("AceLocale-3.0"):GetLocale("TradeSkillMaster") -- loads the localization table
local private = {}



-- ============================================================================
-- Module Functions
-- ============================================================================

function ValueSources.OnInitialize()
	TSM.MainUI.Settings.Tooltip.RegisterTooltipPage(L["ValueSources"], private.GetTooltipSettingsFrame)
end



-- ============================================================================
-- Tooltip Settings UI
-- ============================================================================

function private.GetTooltipSettingsFrame()
	return TSMAPI_FOUR.UI.NewElement("ScrollFrame", "tooltipSettings")
		:SetStyle("padding", 10)
		:AddChild(TSM.MainUI.Settings.CreateHeadingLine("databseSourcesTooptipSettingsTitle", L["Database Sources"]))
		:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "databseSourcesTooptipSettingsDesc")
			:SetStyle("height", 24)
			:SetStyle("margin", { top = -16, bottom = 16 })
			:SetStyle("fontHeight", 16)
			:SetText(L["Requires TSM Desktop Application"])
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "realmTooltipsTitle")
			:SetStyle("height", 24)
			:SetStyle("fontHeight", 18)
			:SetText(L["Realm Tooltips"])
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "minBuyoutCheckbox")
			:SetStyle("height", 35)
			:SetContext("minBuyout")
			:SetText(L["Display min buyout"])
			:SetChecked(TSM.db.global.tooltipOptions.moduleTooltips.AuctionDB.minBuyout)
			:SetScript("OnValueChanged", private.SetValueSourcesTooltipOption)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "marketValueCheckbox")
			:SetStyle("height", 35)
			:SetContext("marketValue")
			:SetText(L["Display market value"])
			:SetChecked(TSM.db.global.tooltipOptions.moduleTooltips.AuctionDB.marketValue)
			:SetScript("OnValueChanged", private.SetValueSourcesTooltipOption)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "historicalPriceCheckbox")
			:SetStyle("height", 35)
			:SetContext("historical")
			:SetText(L["Display historical price"])
			:SetChecked(TSM.db.global.tooltipOptions.moduleTooltips.AuctionDB.historical)
			:SetScript("OnValueChanged", private.SetValueSourcesTooltipOption)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "row1")
			:SetStyle("margin", { top = 16 })
			:SetStyle("height", 24)
			:SetLayout("HORIZONTAL")
			:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "regionTooltipsTitle")
				:SetStyle("height", 24)
				:SetStyle("fontHeight", 18)
				:SetText(L["Region Tooltips"])
			)
			:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "globalTooltipsTitle")
				:SetStyle("height", 24)
				:SetStyle("fontHeight", 18)
				:SetText(L["Global Tooltips"])
			)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "row2")
			:SetStyle("height", 35)
			:SetLayout("HORIZONTAL")
			:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "minRegionBuyoutCheckbox")
				:SetStyle("height", 35)
				:SetContext("regionMinBuyout")
				:SetText(L["Display region min buyout avg"])
				:SetChecked(TSM.db.global.tooltipOptions.moduleTooltips.AuctionDB.regionMinBuyout)
				:SetScript("OnValueChanged", private.SetValueSourcesTooltipOption)
			)
			:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "minGlobalBuyoutCheckbox")
				:SetStyle("height", 35)
				:SetContext("globalMinBuyout")
				:SetText(L["Display global min buyout avg"])
				:SetChecked(TSM.db.global.tooltipOptions.moduleTooltips.AuctionDB.globalMinBuyout)
				:SetScript("OnValueChanged", private.SetValueSourcesTooltipOption)
			)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "row3")
			:SetStyle("height", 35)
			:SetLayout("HORIZONTAL")
			:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "regionMarketValueCheckbox")
				:SetStyle("height", 35)
				:SetContext("regionMarketValue")
				:SetText(L["Display region market value avg"])
				:SetChecked(TSM.db.global.tooltipOptions.moduleTooltips.AuctionDB.regionMarketValue)
				:SetScript("OnValueChanged", private.SetValueSourcesTooltipOption)
			)
			:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "globalMarketValueCheckbox")
				:SetStyle("height", 35)
				:SetContext("globalMarketValue")
				:SetText(L["Display global market value avg"])
				:SetChecked(TSM.db.global.tooltipOptions.moduleTooltips.AuctionDB.globalMarketValue)
				:SetScript("OnValueChanged", private.SetValueSourcesTooltipOption)
			)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "row4")
			:SetStyle("height", 35)
			:SetLayout("HORIZONTAL")
			:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "regionHistoricalCheckbox")
				:SetStyle("height", 35)
				:SetContext("regionHistorical")
				:SetText(L["Display region historical price"])
				:SetChecked(TSM.db.global.tooltipOptions.moduleTooltips.AuctionDB.regionHistorical)
				:SetScript("OnValueChanged", private.SetValueSourcesTooltipOption)
			)
			:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "globalHistoricalCheckbox")
				:SetStyle("height", 35)
				:SetContext("globalHistorical")
				:SetText(L["Display global historical price"])
				:SetChecked(TSM.db.global.tooltipOptions.moduleTooltips.AuctionDB.globalHistorical)
				:SetScript("OnValueChanged", private.SetValueSourcesTooltipOption)
			)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "row5")
			:SetStyle("height", 35)
			:SetLayout("HORIZONTAL")
			:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "regionSaleAvgCheckbox")
				:SetStyle("height", 35)
				:SetContext("regionSale")
				:SetText(L["Display region sale avg"])
				:SetChecked(TSM.db.global.tooltipOptions.moduleTooltips.AuctionDB.regionSale)
				:SetScript("OnValueChanged", private.SetValueSourcesTooltipOption)
			)
			:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "globalSaleAvgCheckbox")
				:SetStyle("height", 35)
				:SetContext("globalSale")
				:SetText(L["Display global sale avg"])
				:SetChecked(TSM.db.global.tooltipOptions.moduleTooltips.AuctionDB.globalSale)
				:SetScript("OnValueChanged", private.SetValueSourcesTooltipOption)
			)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "row6")
			:SetStyle("height", 35)
			:SetLayout("HORIZONTAL")
			:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "regionSaleRateCheckbox")
				:SetStyle("height", 35)
				:SetContext("regionSalePercent")
				:SetText(L["Display region sale rate"])
				:SetChecked(TSM.db.global.tooltipOptions.moduleTooltips.AuctionDB.regionSalePercent)
				:SetScript("OnValueChanged", private.SetValueSourcesTooltipOption)
			)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "row7")
			:SetStyle("margin", { bottom = 16 })
			:SetStyle("height", 35)
			:SetLayout("HORIZONTAL")
			:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "regionAvgDailySoldCheckbox")
				:SetContext("regionSoldPerDay")
				:SetText(L["Display region avg daily sold qty"])
				:SetChecked(TSM.db.global.tooltipOptions.moduleTooltips.AuctionDB.regionSoldPerDay)
				:SetScript("OnValueChanged", private.SetValueSourcesTooltipOption)
			)
		)
		:AddChild(TSM.MainUI.Settings.CreateHeadingLine("customSourcesTooptipSettingsTitle", L["Custom Sources"]))
		:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "customSourcesTooptipSettingsDesc")
			:SetStyle("height", 24)
			:SetStyle("margin", { top = -16, bottom = 16 })
			:SetStyle("fontHeight", 16)
			:SetText(L["Select custom price sources to include in item tooltips"])
		)
		:AddChildrenWithFunction(private.CustomPriceSources)
end

function private.CustomPriceSources(primaryFrame)
	local numCustomPriceSources = 0
	local count = 0
	local priceSourceRow = TSMAPI_FOUR.UI.NewElement("Frame", "customPriceRow")
		:SetStyle("height", 35)
		:SetLayout("HORIZONTAL")

	for name in pairs(TSM.db.global.userData.customPriceSources) do
		numCustomPriceSources = numCustomPriceSources + 1
	end

	for name in pairs(TSM.db.global.userData.customPriceSources) do
		count = count + 1
		priceSourceRow:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "priceSourceCheckbox_" .. name)
			:SetContext(name)
			:SetText(name)
			:SetChecked(TSM.db.global.tooltipOptions.customPriceTooltips[name])
			:SetScript("OnValueChanged", private.SetCustomPriceSourceTooltipOption)
		)

		if priceSourceRow:GetNumLayoutChildren() == 2 then
			primaryFrame:AddChild(priceSourceRow)
			if count < numCustomPriceSources then
				priceSourceRow = TSMAPI_FOUR.UI.NewElement("Frame", "customPriceRow")
					:SetStyle("height", 35)
					:SetLayout("HORIZONTAL")
			end
		end
	end

	if priceSourceRow:GetNumLayoutChildren() == 1 then
		primaryFrame:AddChild(priceSourceRow)
	end
end

function private.SetCustomPriceSourceTooltipOption(self, value)
	TSM.db.global.tooltipOptions.customPriceTooltips[self:GetContext()] = value
end

function private.SetValueSourcesTooltipOption(self, value)
	TSM.db.global.tooltipOptions.moduleTooltips.AuctionDB[self:GetContext()] = value
end
