-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local Shopping = TSM.MainUI.Settings.Tooltip:NewPackage("Shopping")
local L = LibStub("AceLocale-3.0"):GetLocale("TradeSkillMaster") -- loads the localization table
local private = {}



-- ============================================================================
-- Module Functions
-- ============================================================================

function Shopping.OnInitialize()
	TSM.MainUI.Settings.Tooltip.RegisterTooltipPage(L["Shopping"], private.GetTooltipSettingsFrame)
end



-- ============================================================================
-- Tooltip Settings UI
-- ============================================================================

function private.GetTooltipSettingsFrame()
	return TSMAPI_FOUR.UI.NewElement("ScrollFrame", "tooltipSettings")
		:SetStyle("padding", 10)
		:AddChild(TSM.MainUI.Settings.CreateHeadingLine("shoppingTooptipSettingsTitle", L["Shopping Tooltips"]))
		:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "label")
			:SetStyle("height", 35)
			:SetStyle("fontHeight", 16)
			:SetStyle("justifyV", "CENTER")
			:SetText(L["Select which shopping information to display in item tooltips."])
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "maxPriceCheckbox")
			:SetText(L["Display shopping max price"])
			:SetStyle("height", 35)
			:SetContext("maxPrice")
			:SetChecked(TSM.db.global.tooltipOptions.moduleTooltips.Shopping.maxPrice)
			:SetScript("OnValueChanged", private.SetShoppingTooltipOption)
		)
end

function private.SetShoppingTooltipOption(self, value)
	TSM.db.global.tooltipOptions.moduleTooltips.Shopping[self:GetContext()] = value
end