-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local General = TSM.MainUI.Settings.Tooltip:NewPackage("General")
local L = LibStub("AceLocale-3.0"):GetLocale("TradeSkillMaster") -- loads the localization table
local private = {}
local PRICE_FORMAT_VALUES = {format(L["Coins (%s)"], TSMAPI_FOUR.Money.ToString(3451267, "OPT_ICON")), format(L["Text (%s)"], TSMAPI_FOUR.Money.ToString(3451267))};
local PRICE_FORMAT_KEYS = { "icon", "text" }
local MODIFIER_VALUES = { L["None (Always Show)"], ALT_KEY, CTRL_KEY }
local MODIFIER_KEYS = { "none", "alt", "ctrl" }



-- ============================================================================
-- Module Functions
-- ============================================================================

function General.OnInitialize()
	TSM.MainUI.Settings.Tooltip.RegisterTooltipPage(L["General"], private.GetTooltipSettingsFrame)
end



-- ============================================================================
-- Tooltip Settings UI
-- ============================================================================

function private.GetTooltipSettingsFrame()
	return TSMAPI_FOUR.UI.NewElement("ScrollFrame", "tooltipSettings")
		:SetStyle("padding", 10)
		:AddChild(TSM.MainUI.Settings.CreateHeadingLine("generalOptionsTitle", L["General Options"]))
		:AddChild(TSM.MainUI.Settings.CreateSettingLine("embedTooltipFrame", L["Embed TSM tooltips?"])
			:AddChild(TSMAPI_FOUR.UI.NewElement("Toggle", "embedTooltipToggle")
				:SetBooleanToggle(TSM.db.global.tooltipOptions, "embeddedTooltip")
				:SetStyle("width", 80)
				:SetStyle("height", 20)
			)
		)
		:AddChild(TSM.MainUI.Settings.CreateSettingLine("priceFormatFrame", L["Tooltip price format:"])
			:AddChild(TSMAPI_FOUR.UI.NewElement("Dropdown", "priceFormatDropdown")
				:SetItems(PRICE_FORMAT_VALUES, private.PriceFormatKeyToValue(TSM.db.global.tooltipOptions.tooltipPriceFormat))
				:SetScript("OnSelectionChanged", private.SetPriceFormat)
			)
		)
		:AddChild(TSM.MainUI.Settings.CreateSettingLine("modifierFrame", L["Show on Modifier:"])
			:AddChild(TSMAPI_FOUR.UI.NewElement("Dropdown", "modifierDropdown")
				:SetItems(MODIFIER_VALUES, private.ModifiersKeyToValue(TSM.db.global.tooltipOptions.tooltipShowModifier))
				:SetScript("OnSelectionChanged", private.SetModifier)
			)
		)
		:AddChild(TSM.MainUI.Settings.CreateSettingLine("inventoryFormatFrame", L["Inventory tooltip format:"])
			:AddChild(TSMAPI_FOUR.UI.NewElement("Toggle", "inventoryFormatToggle")
				:SetStyle("height", 20)
				:SetStyle("border", "#ffe2e2e2")
				:SetStyle("textColor", "#ffe2e2e2")
				:SetStyle("selectedBackground", "#ffe2e2e2")
				:SetStyle("selectedTextColor", nil)
				:AddOption(L["None"], TSM.db.global.tooltipOptions.inventoryTooltipFormat == "none")
				:AddOption(L["Simple"], TSM.db.global.tooltipOptions.inventoryTooltipFormat == "simple")
				:AddOption(L["Full"], TSM.db.global.tooltipOptions.inventoryTooltipFormat == "full")
				:SetScript("OnValueChanged", private.SetInventoryTooltip)
			)
		)
		:AddChild(TSM.MainUI.Settings.CreateSettingLine("displayGroupNameFrame", L["Display group name in tooltip?"])
			:AddChild(TSMAPI_FOUR.UI.NewElement("Toggle", "displayGroupNameToggle")
				:SetBooleanToggle(TSM.db.global.tooltipOptions, "groupNameTooltip")
				:SetStyle("width", 80)
				:SetStyle("height", 20)
			)
		)
		:AddChild(TSM.MainUI.Settings.CreateSettingLine("displayVendorSellFrame", L["Display vendor sell price in tooltip?"])
			:AddChild(TSMAPI_FOUR.UI.NewElement("Toggle", "displayVendorSellToggle")
				:SetBooleanToggle(TSM.db.global.tooltipOptions, "vendorSellTooltip")
				:SetStyle("width", 80)
				:SetStyle("height", 20)
			)
		)
end



-- ============================================================================
-- Local Script Handlers
-- ============================================================================

function private.SetPriceFormat(self, value)
	TSM.db.global.tooltipOptions.tooltipPriceFormat = private.PriceFormatValueToKey(value)
end

function private.SetModifier(self, value)
	TSM.db.global.tooltipOptions.tooltipShowModifier = private.ModifiersValueToKey(value)
end

function private.SetInventoryTooltip(self, value)
	if value == L["None"] then
		TSM.db.global.tooltipOptions.inventoryTooltipFormat = "none"
	elseif value == L["Simple"] then
		TSM.db.global.tooltipOptions.inventoryTooltipFormat = "simple"
	elseif value == L["Full"] then
		TSM.db.global.tooltipOptions.inventoryTooltipFormat = "full"
	else
		error("Unknown value: "..tostring(value))
	end
end



-- ============================================================================
-- Private Helper Functions
-- ============================================================================

function private.PriceFormatKeyToValue(key)
	for i, v in ipairs(PRICE_FORMAT_KEYS) do
		if v == key then
			return PRICE_FORMAT_VALUES[i]
		end
	end
end


function private.PriceFormatValueToKey(value)
	for i, v in ipairs(PRICE_FORMAT_VALUES) do
		if v == value then
			return PRICE_FORMAT_KEYS[i]
		end
	end
end

function private.ModifiersKeyToValue(key)
	for i, v in ipairs(MODIFIER_KEYS) do
		if v == key then
			return MODIFIER_VALUES[i]
		end
	end
end

function private.ModifiersValueToKey(value)
	for i, v in ipairs(MODIFIER_VALUES) do
		if v == value then
			return MODIFIER_KEYS[i]
		end
	end
end
