-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local Destroying = TSM.MainUI.Settings.Tooltip:NewPackage("Destroying")
local L = LibStub("AceLocale-3.0"):GetLocale("TradeSkillMaster") -- loads the localization table
local private = {}



-- ============================================================================
-- Module Functions
-- ============================================================================

function Destroying.OnInitialize()
	TSM.MainUI.Settings.Tooltip.RegisterTooltipPage(L["Destroying"], private.GetTooltipSettingsFrame)
end



-- ============================================================================
-- Tooltip Settings UI
-- ============================================================================

function private.GetTooltipSettingsFrame()
	return TSMAPI_FOUR.UI.NewElement("ScrollFrame", "tooltipSettings")
		:SetStyle("padding", 10)
		:AddChild(TSM.MainUI.Settings.CreateHeadingLine("destroyingTooptipSettingsTitle", L["Destroying Tooltips"]))
		:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "label")
			:SetStyle("height", 35)
			:SetStyle("fontHeight", 16)
			:SetStyle("justifyV", "CENTER")
			:SetText(L["Select which destroying information to display in item tooltips."])
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "detailedCheckbox")
			:SetText(L["Display detailed destroy tooltips"])
			:SetStyle("height", 35)
			:SetSettingInfo(TSM.db.global.tooltipOptions, "detailedDestroyTooltip")
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "millCheckbox")
			:SetText(L["Display mill value"])
			:SetStyle("height", 35)
			:SetSettingInfo(TSM.db.global.tooltipOptions, "millTooltip")
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "prospectCheckbox")
			:SetText(L["Display prospect value"])
			:SetStyle("height", 35)
			:SetSettingInfo(TSM.db.global.tooltipOptions, "prospectTooltip")
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "disenchantCheckbox")
			:SetText(L["Display disenchant value"])
			:SetStyle("height", 35)
			:SetSettingInfo(TSM.db.global.tooltipOptions, "deTooltip")
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "transformCheckbox")
			:SetText(L["Display transform value"])
			:SetStyle("height", 35)
			:SetSettingInfo(TSM.db.global.tooltipOptions, "transformTooltip")
		)
end
