-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local Crafting = TSM.MainUI.Settings.Tooltip:NewPackage("Crafting")
local L = LibStub("AceLocale-3.0"):GetLocale("TradeSkillMaster") -- loads the localization table
local private = {}



-- ============================================================================
-- Module Functions
-- ============================================================================

function Crafting.OnInitialize()
	TSM.MainUI.Settings.Tooltip.RegisterTooltipPage(L["Crafting"], private.GetTooltipSettingsFrame)
end



-- ============================================================================
-- Tooltip Settings UI
-- ============================================================================

function private.GetTooltipSettingsFrame()
	return TSMAPI_FOUR.UI.NewElement("ScrollFrame", "tooltipSettings")
		:SetStyle("padding", 10)
		:AddChild(TSM.MainUI.Settings.CreateHeadingLine("craftingTooptipSettingsTitle", L["Crafting Tooltips"]))
		:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "craftingTooptipSettingsDesc")
			:SetStyle("height", 35)
			:SetStyle("fontHeight", 16)
			:SetStyle("justifyV", "CENTER")
			:SetText(L["Select which crafting information to display in item tooltips."])
		)		
		:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "craftingCostCheckbox")
			:SetStyle("height", 35)
			:SetContext("craftingCost")
			:SetText(L["Display crafting cost"])
			:SetChecked(TSM.db.global.tooltipOptions.moduleTooltips.Crafting.craftingCost)
			:SetScript("OnValueChanged", private.SetCraftingTooltipOption)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "materialCostCheckbox")
			:SetStyle("height", 35)
			:SetContext("matPrice")
			:SetText(L["Display material cost"])
			:SetChecked(TSM.db.global.tooltipOptions.moduleTooltips.Crafting.matPrice)
			:SetScript("OnValueChanged", private.SetCraftingTooltipOption)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "materialsListCheckbox")
			:SetStyle("height", 35)
			:SetContext("detailedMats")
			:SetText(L["Display list of materials"])
			:SetChecked(TSM.db.global.tooltipOptions.moduleTooltips.Crafting.detailedMats)
			:SetScript("OnValueChanged", private.SetCraftingTooltipOption)
		)
end

function private.SetCraftingTooltipOption(self, value)
	 TSM.db.global.tooltipOptions.moduleTooltips.Crafting[self:GetContext()] = value
end