-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local Tooltip = TSM.MainUI.Settings:NewPackage("Tooltip")
local L = LibStub("AceLocale-3.0"):GetLocale("TradeSkillMaster") -- loads the localization table
local private = { moduleNames = {}, callback = {} }



-- ============================================================================
-- Module Functions
-- ============================================================================

function Tooltip.OnInitialize()
	TSM.MainUI.Settings.RegisterSettingPage("Tooltip Settings", "top", private.GetTooltipSettings)
end

function Tooltip.RegisterTooltipPage(name, callback)
	tinsert(private.moduleNames, name)
	private.callback[name] = callback
end



-- ============================================================================
-- Tooltip Settings UI
-- ============================================================================

function private.GetTooltipSettings()
	local frame = TSMAPI_FOUR.UI.NewElement("Frame", "content")
		:SetLayout("VERTICAL")
		:AddChild(TSMAPI_FOUR.UI.NewElement("ButtonGroup", "buttons")
			:SetStyle("buttonWidth", 120)
			:SetNavCallback(private.GetTooltipModuleSettings)
		)

	local buttons = frame:GetElement("buttons")
	for i, moduleName in ipairs(private.moduleNames) do
		buttons:AddPath(moduleName, moduleName == L["General"])
	end

	return frame
end

function private.GetTooltipModuleSettings(self, button)
	return private.callback[button]()
end