-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local Accounting = TSM.MainUI.Settings.Tooltip:NewPackage("Accounting")
local L = LibStub("AceLocale-3.0"):GetLocale("TradeSkillMaster") -- loads the localization table
local private = {}



-- ============================================================================
-- Module Functions
-- ============================================================================

function Accounting.OnInitialize()
	TSM.MainUI.Settings.Tooltip.RegisterTooltipPage(L["Accounting"], private.GetTooltipSettingsFrame)
end



-- ============================================================================
-- Tooltip Settings UI
-- ============================================================================

function private.GetTooltipSettingsFrame()
	return TSMAPI_FOUR.UI.NewElement("ScrollFrame", "tooltipSettings")
		:SetStyle("padding", 10)
		:AddChild(TSM.MainUI.Settings.CreateHeadingLine("accountingTooptipSettingsTitle", L["Accounting Tooltips"]))
		:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "label")
			:SetStyle("height", 35)
			:SetStyle("fontHeight", 16)
			:SetStyle("justifyV", "CENTER")
			:SetText(L["Select which accounting information to display in item tooltips."])
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "saleInfoCheckbox")
			:SetText(L["Show sale info"])
			:SetStyle("height", 35)
			:SetContext("sale")
			:SetChecked(TSM.db.global.tooltipOptions.moduleTooltips.Accounting.sale)
			:SetScript("OnValueChanged", private.SetAccountingTooltipOption)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "expiredCheckbox")
			:SetText(L["Show expired auctions since last sale"])
			:SetStyle("height", 35)
			:SetContext("expiredAuctions")
			:SetChecked(TSM.db.global.tooltipOptions.moduleTooltips.Accounting.expiredAuctions)
			:SetScript("OnValueChanged", private.SetAccountingTooltipOption)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "cancelledCheckbox")
			:SetText(L["Show cancelled auctions since last sale"])
			:SetStyle("height", 35)
			:SetContext("cancelledAuctions")
			:SetChecked(TSM.db.global.tooltipOptions.moduleTooltips.Accounting.cancelledAuctions)
			:SetScript("OnValueChanged", private.SetAccountingTooltipOption)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "saleRateCheckbox")
			:SetText(L["Show sale rate"])
			:SetStyle("height", 35)
			:SetContext("saleRate")
			:SetChecked(TSM.db.global.tooltipOptions.moduleTooltips.Accounting.saleRate)
			:SetScript("OnValueChanged", private.SetAccountingTooltipOption)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Checkbox", "materialsListCheckbox")
			:SetText(L["Show purchase info"])
			:SetStyle("height", 35)
			:SetContext("purchase")
			:SetChecked(TSM.db.global.tooltipOptions.moduleTooltips.Accounting.purchase)
			:SetScript("OnValueChanged", private.SetAccountingTooltipOption)
		)
end

function private.SetAccountingTooltipOption(self, value)
	 TSM.db.global.tooltipOptions.moduleTooltips.Accounting[self:GetContext()] = value
end
