-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local Warehousing = TSM.MainUI.Operations:NewPackage("Warehousing")
local L = LibStub("AceLocale-3.0"):GetLocale("TradeSkillMaster") -- loads the localization table
local private = { currentOperationName = nil }



-- ============================================================================
-- Module Functions
-- ============================================================================

function Warehousing.OnInitialize()
	TSM.MainUI.Operations.RegisterModule("Warehousing", private.GetWarehousingOperationSettings)
end



-- ============================================================================
-- Warehousing Operation Settings UI
-- ============================================================================

function private.GetWarehousingOperationSettings(operationName)
	private.currentOperationName = operationName
	local operation = TSM.operations.Warehousing[private.currentOperationName]
	return TSMAPI_FOUR.UI.NewElement("Frame", "content")
		:SetLayout("VERTICAL")
		:AddChild(TSMAPI_FOUR.UI.NewElement("Texture", "line")
			:SetStyle("color", "#9d9d9d")
			:SetStyle("height", 2)
			:SetStyle("margin", { top = 24 })
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("ScrollFrame", "settings")
			:SetStyle("background", "#1e1e1e")
			:SetStyle("padding", { left = 16, right = 16, top = -8 })
			:AddChild(TSM.MainUI.Operations.CreateHeadingLine("buyOptionsHeading", L["Move Quantity Settings"]))
			:AddChild(TSM.MainUI.Operations.CreateLinkedSettingLine("moveQtyEnabled", L["Set move quantity?"])
				:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "enableBuyingFrame")
					:SetLayout("HORIZONTAL")
					-- move the right by the width of the toggle so this frame gets half the total width
					:SetStyle("margin", { right = -TSM.UI.TexturePacks.GetWidth("uiFrames.ToggleOn") })
					:AddChild(TSMAPI_FOUR.UI.NewElement("ToggleOnOff", "toggle")
						:SetSettingInfo(operation, "moveQtyEnabled")
						:SetScript("OnValueChanged", private.MoveQtyEnabledOnClick)
					)
					:AddChild(TSMAPI_FOUR.UI.NewElement("Spacer", "spacer"))
				)
			)
			:AddChild(TSM.MainUI.Operations.CreateSettingLine("moveQtyFrame", L["Quantity to move:"], not operation.moveQtyEnabled)
				:SetStyle("margin", { left = 25, right = -85, bottom = 16 })
				:AddChild(TSMAPI_FOUR.UI.NewElement("InputNumeric", "moveQtyInput")
					:SetStyle("backgroundTexturePacks", "uiFrames.ActiveInputField")
					:SetStyle("width", 96)
					:SetStyle("height", 24)
					:SetStyle("margin", { right = 16 })
					:SetStyle("justifyH", "CENTER")
					:SetStyle("font", TSM.UI.Fonts.bold)
					:SetStyle("fontHeight", 16)
					:SetDisabled(not operation.moveQtyEnabled)
					:SetSettingInfo(operation, "moveQuantity")
					:SetMaxNumber(5000)
				)
				:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "moveQtyLabel")
					:SetStyle("fontHeight", 14)
					:SetStyle("textColor", operation.moveQtyEnabled and "#e2e2e2" or "#424242")
					:SetText(L["(max 5000)"])
				)
			)
			:AddChild(TSM.MainUI.Operations.CreateLinkedSettingLine("stackSizeEnabled", L["Set stack size for bags?"])
				:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "enableBuyingFrame")
					:SetLayout("HORIZONTAL")
					-- move the right by the width of the toggle so this frame gets half the total width
					:SetStyle("margin", { right = -TSM.UI.TexturePacks.GetWidth("uiFrames.ToggleOn") })
					:AddChild(TSMAPI_FOUR.UI.NewElement("ToggleOnOff", "toggle")
						:SetSettingInfo(operation, "stackSizeEnabled")
						:SetScript("OnValueChanged", private.StackSizeEnabledOnClick)
					)
					:AddChild(TSMAPI_FOUR.UI.NewElement("Spacer", "spacer"))
				)
			)
			:AddChild(TSM.MainUI.Operations.CreateSettingLine("stackSizeFrame", L["Stack size multiple:"], not operation.stackSizeEnabled)
				:SetStyle("margin", { left = 25, right = -85, bottom = 16 })
				:AddChild(TSMAPI_FOUR.UI.NewElement("InputNumeric", "stackSizeInput")
					:SetStyle("backgroundTexturePacks", "uiFrames.ActiveInputField")
					:SetStyle("width", 96)
					:SetStyle("height", 24)
					:SetStyle("margin", { right = 16 })
					:SetStyle("justifyH", "CENTER")
					:SetStyle("font", TSM.UI.Fonts.bold)
					:SetStyle("fontHeight", 16)
					:SetDisabled(not operation.stackSizeEnabled)
					:SetSettingInfo(operation, "stackSize")
					:SetMaxNumber(200)
				)
				:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "stackSizeLabel")
					:SetStyle("fontHeight", 14)
					:SetStyle("textColor", operation.stackSizeEnabled and "#e2e2e2" or "#424242")
					:SetText(L["(max 200)"])
				)
			)
			:AddChild(TSM.MainUI.Operations.CreateLinkedSettingLine("keepBagQtyEnabled", L["Set keep in bags quantity?"])
				:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "enableBuyingFrame")
					:SetLayout("HORIZONTAL")
					-- move the right by the width of the toggle so this frame gets half the total width
					:SetStyle("margin", { right = -TSM.UI.TexturePacks.GetWidth("uiFrames.ToggleOn") })
					:AddChild(TSMAPI_FOUR.UI.NewElement("ToggleOnOff", "toggle")
						:SetSettingInfo(operation, "keepBagQtyEnabled")
						:SetScript("OnValueChanged", private.KeepBagQtyEnabledOnClick)
					)
					:AddChild(TSMAPI_FOUR.UI.NewElement("Spacer", "spacer"))
				)
			)
			:AddChild(TSM.MainUI.Operations.CreateSettingLine("keepBagFrame", L["Keep in bags quantity:"], not operation.keepBagQtyEnabled)
				:SetStyle("margin", { left = 25, right = -85, bottom = 16 })
				:AddChild(TSMAPI_FOUR.UI.NewElement("InputNumeric", "keepBagInput")
					:SetStyle("backgroundTexturePacks", "uiFrames.ActiveInputField")
					:SetStyle("width", 96)
					:SetStyle("height", 24)
					:SetStyle("margin", { right = 16 })
					:SetStyle("justifyH", "CENTER")
					:SetStyle("font", TSM.UI.Fonts.bold)
					:SetStyle("fontHeight", 16)
					:SetDisabled(not operation.keepBagQtyEnabled)
					:SetSettingInfo(operation, "keepBagQuantity")
					:SetMaxNumber(5000)
				)
				:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "keepBagLabel")
					:SetStyle("fontHeight", 14)
					:SetStyle("textColor", operation.keepBagQtyEnabled and "#e2e2e2" or "#424242")
					:SetText(L["(max 5000)"])
				)
			)
			:AddChild(TSM.MainUI.Operations.CreateLinkedSettingLine("keepBankQtyEnabled", L["Set keep in bank quantity?"])
				:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "enableBuyingFrame")
					:SetLayout("HORIZONTAL")
					-- move the right by the width of the toggle so this frame gets half the total width
					:SetStyle("margin", { right = -TSM.UI.TexturePacks.GetWidth("uiFrames.ToggleOn") })
					:AddChild(TSMAPI_FOUR.UI.NewElement("ToggleOnOff", "toggle")
						:SetSettingInfo(operation, "keepBankQtyEnabled")
						:SetScript("OnValueChanged", private.KeepBankQtyEnabledOnClick)
					)
					:AddChild(TSMAPI_FOUR.UI.NewElement("Spacer", "spacer"))
				)
			)
			:AddChild(TSM.MainUI.Operations.CreateSettingLine("keepBankFrame", L["Keep in bank quantity:"], not operation.keepBankQtyEnabled)
				:SetStyle("margin", { left = 25, right = -85, bottom = 16 })
				:AddChild(TSMAPI_FOUR.UI.NewElement("InputNumeric", "keepBankInput")
					:SetStyle("backgroundTexturePacks", "uiFrames.ActiveInputField")
					:SetStyle("width", 96)
					:SetStyle("height", 24)
					:SetStyle("margin", { right = 16 })
					:SetStyle("justifyH", "CENTER")
					:SetStyle("font", TSM.UI.Fonts.bold)
					:SetStyle("fontHeight", 16)
					:SetDisabled(not operation.keepBankQtyEnabled)
					:SetSettingInfo(operation, "keepBankQuantity")
					:SetMaxNumber(5000)
				)
				:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "keepBankLabel")
					:SetStyle("fontHeight", 14)
					:SetStyle("textColor", operation.keepBankQtyEnabled and "#e2e2e2" or "#424242")
					:SetText(L["(max 5000)"])
				)
			)
			:AddChild(TSM.MainUI.Operations.CreateHeadingLine("restockSettings", L["Restock Settings"]))
			:AddChild(TSM.MainUI.Operations.CreateLinkedSettingLine("restockQtyEnabled", L["Enable restock?"])
				:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "enableBuyingFrame")
					:SetLayout("HORIZONTAL")
					-- move the right by the width of the toggle so this frame gets half the total width
					:SetStyle("margin", { right = -TSM.UI.TexturePacks.GetWidth("uiFrames.ToggleOn") })
					:AddChild(TSMAPI_FOUR.UI.NewElement("ToggleOnOff", "toggle")
						:SetSettingInfo(operation, "restockQtyEnabled")
						:SetScript("OnValueChanged", private.RestockQtyEnabledOnClick)
					)
					:AddChild(TSMAPI_FOUR.UI.NewElement("Spacer", "spacer"))
				)
			)
			:AddChild(TSM.MainUI.Operations.CreateSettingLine("restockFrame", L["Restock quantity:"], not operation.restockQtyEnabled)
				:SetStyle("margin", { left = 25, right = -85, bottom = 16 })
				:AddChild(TSMAPI_FOUR.UI.NewElement("InputNumeric", "restockInput")
					:SetStyle("backgroundTexturePacks", "uiFrames.ActiveInputField")
					:SetStyle("width", 96)
					:SetStyle("height", 24)
					:SetStyle("margin", { right = 16 })
					:SetStyle("justifyH", "CENTER")
					:SetStyle("font", TSM.UI.Fonts.bold)
					:SetStyle("fontHeight", 16)
					:SetDisabled(not operation.restockQtyEnabled)
					:SetSettingInfo(operation, "restockQuantity")
					:SetMaxNumber(5000)
				)
				:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "restockLabel")
					:SetStyle("fontHeight", 14)
					:SetStyle("textColor", operation.restockQtyEnabled and "#e2e2e2" or "#424242")
					:SetText(L["(max 5000)"])
				)
			)
			:AddChild(TSM.MainUI.Operations.CreateLinkedSettingLine("restockStackSizeEnabled", L["Set stack size for bags?"])
				:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "enableBuyingFrame")
					:SetLayout("HORIZONTAL")
					-- move the right by the width of the toggle so this frame gets half the total width
					:SetStyle("margin", { right = -TSM.UI.TexturePacks.GetWidth("uiFrames.ToggleOn") })
					:AddChild(TSMAPI_FOUR.UI.NewElement("ToggleOnOff", "toggle")
						:SetSettingInfo(operation, "restockStackSizeEnabled")
						:SetScript("OnValueChanged", private.RestockStackSizeEnabledOnClick)
					)
					:AddChild(TSMAPI_FOUR.UI.NewElement("Spacer", "spacer"))
				)
			)
			:AddChild(TSM.MainUI.Operations.CreateSettingLine("restockStackSizeFrame", L["Stack size multiple:"], not operation.restockStackSizeEnabled)
				:SetStyle("margin", { left = 25, right = -85, bottom = 16 })
				:AddChild(TSMAPI_FOUR.UI.NewElement("InputNumeric", "restockStackSizeInput")
					:SetStyle("backgroundTexturePacks", "uiFrames.ActiveInputField")
					:SetStyle("width", 96)
					:SetStyle("height", 24)
					:SetStyle("margin", { right = 16 })
					:SetStyle("justifyH", "CENTER")
					:SetStyle("font", TSM.UI.Fonts.bold)
					:SetStyle("fontHeight", 16)
					:SetDisabled(not operation.restockStackSizeEnabled)
					:SetSettingInfo(operation, "restockStackSize")
					:SetMaxNumber(200)
				)
				:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "restockStackSizeLabel")
					:SetStyle("fontHeight", 14)
					:SetStyle("textColor", operation.restockStackSizeEnabled and "#e2e2e2" or "#424242")
					:SetText(L["(max 200)"])
				)
			)
			:AddChild(TSM.MainUI.Operations.CreateLinkedSettingLine("restockKeepBankQtyEnabled", L["Set keep in bank quantity?"])
				:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "enableBuyingFrame")
					:SetLayout("HORIZONTAL")
					-- move the right by the width of the toggle so this frame gets half the total width
					:SetStyle("margin", { right = -TSM.UI.TexturePacks.GetWidth("uiFrames.ToggleOn") })
					:AddChild(TSMAPI_FOUR.UI.NewElement("ToggleOnOff", "toggle")
						:SetSettingInfo(operation, "restockKeepBankQtyEnabled")
						:SetScript("OnValueChanged", private.RestockKeepBankQtyEnabledOnClick)
					)
					:AddChild(TSMAPI_FOUR.UI.NewElement("Spacer", "spacer"))
				)
			)
			:AddChild(TSM.MainUI.Operations.CreateSettingLine("restockKeepBankFrame", L["Keep in bank quantity:"], not operation.restockKeepBankQtyEnabled)
				:SetStyle("margin", { left = 25, right = -85, bottom = 16 })
				:AddChild(TSMAPI_FOUR.UI.NewElement("InputNumeric", "restockKeepBankInput")
					:SetStyle("backgroundTexturePacks", "uiFrames.ActiveInputField")
					:SetStyle("width", 96)
					:SetStyle("height", 24)
					:SetStyle("margin", { right = 16 })
					:SetStyle("justifyH", "CENTER")
					:SetStyle("font", TSM.UI.Fonts.bold)
					:SetStyle("fontHeight", 16)
					:SetDisabled(not operation.restockKeepBankQtyEnabled)
					:SetSettingInfo(operation, "restockKeepBankQuantity")
					:SetMaxNumber(5000)
				)
				:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "restockKeepBankLabel")
					:SetStyle("fontHeight", 14)
					:SetStyle("textColor", operation.restockKeepBankQtyEnabled and "#e2e2e2" or "#424242")
					:SetText(L["(max 5000)"])
				)
			)
			:AddChild(TSM.MainUI.Operations.GetOperationManagementElements("Warehousing", private.currentOperationName))
		)
end



-- ============================================================================
-- Local Script Handlers
-- ============================================================================

function private.MoveQtyEnabledOnClick(self, value)
	local moveQtyFrame = self:GetElement("__parent.__parent.__parent.moveQtyFrame")
	local label = moveQtyFrame:GetElement("label")
	local moveQtyLabel = moveQtyFrame:GetElement("moveQtyLabel")
	local moveQtyInput = moveQtyFrame:GetElement("moveQtyInput")
	label:SetStyle("textColor", value and "#e2e2e2" or "#424242")
	moveQtyLabel:SetStyle("textColor", value and "#e2e2e2" or "#424242")
	moveQtyInput:SetDisabled(not value)
	moveQtyFrame:Draw()
end

function private.StackSizeEnabledOnClick(self, value)
	local stackSizeFrame = self:GetElement("__parent.__parent.__parent.stackSizeFrame")
	local label = stackSizeFrame:GetElement("label")
	local stackSizeLabel = stackSizeFrame:GetElement("stackSizeLabel")
	local stackSizeInput = stackSizeFrame:GetElement("stackSizeInput")
	label:SetStyle("textColor", value and "#e2e2e2" or "#424242")
	stackSizeLabel:SetStyle("textColor", value and "#e2e2e2" or "#424242")
	stackSizeInput:SetDisabled(not value)
	stackSizeFrame:Draw()
end

function private.KeepBagQtyEnabledOnClick(self, value)
	local keepBagFrame = self:GetElement("__parent.__parent.__parent.keepBagFrame")
	local label = keepBagFrame:GetElement("label")
	local keepBagLabel = keepBagFrame:GetElement("keepBagLabel")
	local keepBagInput = keepBagFrame:GetElement("keepBagInput")
	label:SetStyle("textColor", value and "#e2e2e2" or "#424242")
	keepBagLabel:SetStyle("textColor", value and "#e2e2e2" or "#424242")
	keepBagInput:SetDisabled(not value)
	keepBagFrame:Draw()
end

function private.KeepBankQtyEnabledOnClick(self, value)
	local keepBankFrame = self:GetElement("__parent.__parent.__parent.keepBankFrame")
	local label = keepBankFrame:GetElement("label")
	local keepBankLabel = keepBankFrame:GetElement("keepBankLabel")
	local keepBankInput = keepBankFrame:GetElement("keepBankInput")
	label:SetStyle("textColor", value and "#e2e2e2" or "#424242")
	keepBankLabel:SetStyle("textColor", value and "#e2e2e2" or "#424242")
	keepBankInput:SetDisabled(not value)
	keepBankFrame:Draw()
end

function private.RestockQtyEnabledOnClick(self, value)
	local restockFrame = self:GetElement("__parent.__parent.__parent.restockFrame")
	local label = restockFrame:GetElement("label")
	local restockLabel = restockFrame:GetElement("restockLabel")
	local restockInput = restockFrame:GetElement("restockInput")
	label:SetStyle("textColor", value and "#e2e2e2" or "#424242")
	restockLabel:SetStyle("textColor", value and "#e2e2e2" or "#424242")
	restockInput:SetDisabled(not value)
	restockFrame:Draw()
end

function private.RestockStackSizeEnabledOnClick(self, value)
	local restockStackSizeFrame = self:GetElement("__parent.__parent.__parent.restockStackSizeFrame")
	local label = restockStackSizeFrame:GetElement("label")
	local restockStackSizeLabel = restockStackSizeFrame:GetElement("restockStackSizeLabel")
	local restockStackSizeInput = restockStackSizeFrame:GetElement("restockStackSizeInput")
	label:SetStyle("textColor", value and "#e2e2e2" or "#424242")
	restockStackSizeLabel:SetStyle("textColor", value and "#e2e2e2" or "#424242")
	restockStackSizeInput:SetDisabled(not value)
	restockStackSizeFrame:Draw()
end

function private.RestockKeepBankQtyEnabledOnClick(self, value)
	local restockKeepBankFrame = self:GetElement("__parent.__parent.__parent.restockKeepBankFrame")
	local label = restockKeepBankFrame:GetElement("label")
	local restockKeepBankLabel = restockKeepBankFrame:GetElement("restockKeepBankLabel")
	local restockKeepBankInput = restockKeepBankFrame:GetElement("restockKeepBankInput")
	label:SetStyle("textColor", value and "#e2e2e2" or "#424242")
	restockKeepBankLabel:SetStyle("textColor", value and "#e2e2e2" or "#424242")
	restockKeepBankInput:SetDisabled(not value)
	restockKeepBankFrame:Draw()
end