-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local Ledger = TSM.MainUI:NewPackage("Ledger")
local L = LibStub("AceLocale-3.0"):GetLocale("TradeSkillMaster") -- loads the localization table
local private = {}
local TIMELIST, TIMELIST_ORDER, RARITY_LIST, RARITY_LIST_ORDER = nil, nil, nil, nil
local SHOW_TSM3_UI = true



-- ============================================================================
-- Module Functions
-- ============================================================================

function Ledger.OnInitialize()
	TSM.MainUI.RegisterTopLevelPage("Ledger", "iconPack.24x24/Inventory", private.GetLedgerFrame)

	TIMELIST = {[99]=L["All"], [0]=L["Today"], [1]=L["Yesterday"]}
	for _, days in TSMAPI_FOUR.Util.VarargIterator(7, 14, 30, 60) do
		TIMELIST[days] = format(L["Last %d Days"], days)
	end
	TIMELIST_ORDER = { 0, 1, 7, 14, 30, 60, 99 }
	RARITY_LIST = {[0]=L["None"]}
	for i = 1, 4 do
		RARITY_LIST[i] = _G[format("ITEM_QUALITY%d_DESC", i)]
	end
	RARITY_LIST_ORDER = { 0, 1, 2, 3, 4 }
end



-- ============================================================================
-- Ledger UI
-- ============================================================================

function private.GetLedgerFrame()
	if SHOW_TSM3_UI then
		-- temporarily show the TSM3 UI since the TSM4 one isn't ready yet
		local frame = TSMAPI_FOUR.UI.NewElement("Frame", "accounting")
			:SetLayout("VERTICAL")
			:SetStyle("padding", { top = 30 })
			:SetStyle("background", "#171717")
			:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "text")
				:SetStyle("height", 20)
				:SetStyle("textColor", "#ff2222")
				:SetStyle("justifyH", "CENTER")
				:SetText("This is a temporary view of the TSM3 UI until this one is updated for TSM4.")
			)
			:AddChild(TSMAPI_FOUR.UI.NewElement("Texture", "line")
				:SetStyle("height", 2)
				:SetStyle("color", "#9d9d9d")
				:SetStyle("margin", { top = 16, bottom = 16 })
			)
			:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "content"))

		if not private.tsm3SimpleFrame then
			private.tsm3SimpleFrame = LibStub("AceGUI-3.0"):Create("TSMSimpleFrame")
			private.tsm3SimpleFrame:SetLayout("Fill")
		else
			private.tsm3SimpleFrame:Show()
		end
		if #private.tsm3SimpleFrame.children > 0 then
			private.tsm3SimpleFrame:ReleaseChildren()
		end
		private.tsm3SimpleFrame.frame:SetParent(frame:GetElement("content"):_GetBaseFrame())
		private.tsm3SimpleFrame.frame:SetAllPoints()
		TSM.old.Accounting.Viewer.Load(private.tsm3SimpleFrame)
		frame:SetScript("OnHide", function()
			private.tsm3SimpleFrame:Hide()
		end)
		return frame
	end

	return TSMAPI_FOUR.UI.NewElement("Frame", "accounting")
		:SetLayout("HORIZONTAL")
		:SetStyle("background", "#363636")
		:AddChild(TSMAPI_FOUR.UI.NewElement("VerticalNav", "verticalNav")
			:SetNavCallback(private.VerticalNavCallback)
			:AddPath(L["Revenue"], true)
			:AddPath(L["Expenses"])
			:AddPath(L["Failed Auctions"])
			:AddPath(L["Items"])
			:AddPath(L["Summary"])
		)
end

function private.VerticalNavCallback(self, button)
	if button == L["Revenue"] then
		return private.DisplayRevenue()
	end
end

function private.DisplayRevenue()
	return TSMAPI_FOUR.UI.NewElement("Frame", "content")
		:SetLayout("VERTICAL")
		:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "firstRow")
			:SetLayout("HORIZONTAL")
			:SetStyle("height", 60)
			:SetStyle("margin", { top = 40 })
			:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "searchFrame")
				:SetLayout("VERTICAL")
				:SetStyle("margin", { bottom = 16 })
				:SetStyle("width", 200)
				:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "label")
					:SetStyle("fontHeight", 18)
					:SetText(L["SEARCH"])
				)
				:AddChild(TSMAPI_FOUR.UI.NewElement("Input", "searchInput")
					:SetStyle("background", "#1ae2e2e2")
					:SetStyle("justifyH", "LEFT")
					:SetText("")
				)
			)
			:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "groupFrame")
				:SetLayout("VERTICAL")
				:SetStyle("margin", { bottom = 16, left = 20 })
				:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "label")
					:SetStyle("textColor", "#e2e2e2")
					:SetStyle("fontHeight", 18)
					:SetStyle("justifyV", "CENTER")
					:SetStyle("width", 200)
					:SetText(L["GROUP"])
				)
				:AddChild(TSMAPI_FOUR.UI.NewElement("Input", "groupInput")
					:SetStyle("background", "#1ae2e2e2")
				)
			)
			:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "typeFrame")
				:SetLayout("VERTICAL")
				:SetStyle("margin", { bottom = 16, left = 20, right = 20 })
				:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "label")
					:SetStyle("textColor", "#e2e2e2")
					:SetStyle("fontHeight", 18)
					:SetStyle("justifyV", "CENTER")
					:SetStyle("width", 200)
					:SetText(L["TYPE"])
				)
				:AddChild(TSMAPI_FOUR.UI.NewElement("Input", "typeInput")
					:SetStyle("background", "#1ae2e2e2")
					:SetStyle("justifyH", "LEFT")
					:SetText("")
				)
			)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "secondRow")
			:SetLayout("HORIZONTAL")
			:SetStyle("height", 60)
			:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "rarityFrame")
				:SetLayout("VERTICAL")
				:SetStyle("margin", { bottom = 16 })
				:SetStyle("width", 200)
				:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "label")
					:SetStyle("textColor", "#e2e2e2")
					:SetStyle("fontHeight", 18)
					:SetStyle("justifyV", "CENTER")
					:SetStyle("width", 200)
					:SetText(L["RARITY"])
				)
				:AddChild(TSMAPI_FOUR.UI.NewElement("Dropdown", "rarityInput")
					:SetDictionaryItems(RARITY_LIST, L["None"], RARITY_LIST_ORDER)
				)
			)
			:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "characterFrame")
				:SetLayout("VERTICAL")
				:SetStyle("margin", { bottom = 16, left = 20 })
				:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "label")
					:SetStyle("textColor", "#e2e2e2")
					:SetStyle("fontHeight", 18)
					:SetStyle("justifyV", "CENTER")
					:SetStyle("width", 200)
					:SetText(L["CHARACTER"])
				)
				:AddChild(TSMAPI_FOUR.UI.NewElement("Input", "characterInput")
					:SetStyle("background", "#1ae2e2e2")
					:SetStyle("justifyH", "LEFT")
					:SetText("")
				)
			)
			:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "timeFrameFrame")
				:SetLayout("VERTICAL")
				:SetStyle("margin", { bottom = 16, left = 20, right = 20 })
				:AddChild(TSMAPI_FOUR.UI.NewElement("Text", "label")
					:SetStyle("textColor", "#e2e2e2")
					:SetStyle("fontHeight", 18)
					:SetStyle("justifyV", "CENTER")
					:SetStyle("width", 200)
					:SetText(L["TIME FRAME"])
				)
				:AddChild(TSMAPI_FOUR.UI.NewElement("Dropdown", "timeFrameInput")
					:SetDictionaryItems(TIMELIST, L["Last 30 Days"], TIMELIST_ORDER)
				)
			)
		)
		:AddChild(TSMAPI_FOUR.UI.NewElement("Frame", "accountingScrollingTableFrame")
			:SetLayout("VERTICAL")
			:SetStyle("margin", { right = 20 })
			:AddChild(TSMAPI_FOUR.UI.NewElement("Texture", "line")
				:SetStyle("height", 2)
				:SetStyle("color", "#9d9d9d")
			)
			:AddChild(TSMAPI_FOUR.UI.NewElement("ScrollingTable", "scrollingTable")
				:GetScrollingTableInfo()
				:NewColumn("item")
					:SetTitles(L["Item"])
					:SetJustifyH("LEFT")
					:Commit()
				:NewColumn("player")
					:SetTitles(L["Player"])
					:SetJustifyH("LEFT")
					:Commit()
				:NewColumn("type")
					:SetTitles(L["Type"])
					:SetWidth(80)
					:SetJustifyH("LEFT")
					:Commit()
				:NewColumn("stack")
					:SetTitles(L["Stack"])
					:SetWidth(40)
					:SetJustifyH("RIGHT")
					:Commit()
				:NewColumn("auctions")
					:SetTitles(L["Auctions"])
					:SetWidth(40)
					:SetJustifyH("RIGHT")
					:Commit()
				:NewColumn("perItem")
					:SetTitles(L["Per Item"])
					:SetJustifyH("RIGHT")
					:Commit()
				:NewColumn("timeFrame")
					:SetTitles(L["Time Frame"])
					:SetJustifyH("RIGHT")
					:Commit()
				:SetDefaultSort("item", true)
				:Commit()
			)
		)
end
