-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local ViewContainer = TSMAPI_FOUR.Class.DefineClass("ViewContainer", TSM.UI.Container)
TSM.UI.ViewContainer = ViewContainer

function ViewContainer.__init(self)
	local frame = CreateFrame("Frame", nil, nil, nil)
	self.__super:__init(frame)
	self._pathsList = {}
	self._pathContext = {}
end

function ViewContainer.Acquire(self)
	self._path = nil
	self._navCallback = nil
	self.__super:Acquire()
end

function ViewContainer.Release(self)
	wipe(self._pathsList)
	wipe(self._pathContext)
	self.__super:Release()
end

function ViewContainer.SetLayout(self, layout)
	error("ViewContainer doesn't support this method")
end

function ViewContainer.AddChild(self, child)
	error("ViewContainer doesn't support this method")
end

function ViewContainer.AddChildNoLayout(self, child)
	error("ViewContainer doesn't support this method")
end

function ViewContainer.SetNavCallback(self, callback)
	self._navCallback = callback
	return self
end

function ViewContainer.AddPath(self, path, setSelected, context)
	tinsert(self._pathsList, path)
	self._pathContext[path] = context
	if setSelected then
		self:SetPath(path)
	end
	return self
end

function ViewContainer.RenamePath(self, path, index)
	local changePath = self._pathsList[index] == self._path
	self._pathsList[index] = path

	if changePath then
		self:SetPath(path)
	end
	return self
end

function ViewContainer.SetPath(self, path, redraw)
	if path ~= self._path then
		local child = self:_GetChild()
		if child then
			assert(#self._layoutChildren == 1)
			self:RemoveChild(child)
			child:Release()
		end
		self.__super:AddChild(self:_navCallback(path))
		self._path = path
	end
	if redraw then
		self:Draw()
	end
	return self
end

function ViewContainer.ReloadContent(self)
	local path = self._path
	self._path = nil
	self:SetPath(path, true)
end

function ViewContainer.GetPath(self)
	return self._path
end

function ViewContainer._GetMinimumDimension(self, dimension)
	if dimension == "WIDTH" then
		local width = self:_GetStyle("width")
		if width then
			return width, false
		else
			return self:_GetChild():_GetMinimumDimension(dimension)
		end
	elseif dimension == "HEIGHT" then
		local height = self:_GetStyle("height")
		if height then
			return height, false
		else
			return self:_GetChild():_GetMinimumDimension(dimension)
		end
	else
		error("Invalid dimension: "..tostring(dimension))
	end
end

function ViewContainer._GetContentPadding(self, side)
	if side == "TOP" then
		return 0
	elseif side == "BOTTOM" then
		return 0
	elseif side == "LEFT" then
		return 0
	elseif side == "RIGHT" then
		return 0
	else
		error("Invalid side: "..tostring(side))
	end
end

function ViewContainer._GetChild(self)
	return self._layoutChildren[1]
end

function ViewContainer.Draw(self)
	self.__super.__super:Draw()
	local child = self:_GetChild()
	local childFrame = child:_GetBaseFrame()

	-- set the child to be full-size
	childFrame:ClearAllPoints()
	local xOffset, yOffset = child:_GetMarginAnchorOffsets("BOTTOMLEFT")
	local paddingXOffset, paddingYOffset = self:_GetPaddingAnchorOffsets("BOTTOMLEFT")
	xOffset = xOffset + paddingXOffset - self:_GetContentPadding("LEFT")
	yOffset = yOffset + paddingYOffset - self:_GetContentPadding("BOTTOM")
	childFrame:SetPoint("BOTTOMLEFT", xOffset, yOffset)
	local xOffset, yOffset = child:_GetMarginAnchorOffsets("TOPRIGHT")
	local paddingXOffset, paddingYOffset = self:_GetPaddingAnchorOffsets("TOPRIGHT")
	xOffset = xOffset + paddingXOffset - self:_GetContentPadding("RIGHT")
	yOffset = yOffset + paddingYOffset - self:_GetContentPadding("TOP")
	childFrame:SetPoint("TOPRIGHT", xOffset, yOffset)
	child:Draw()

	-- draw the no-layout children
	for _, child in ipairs(self._noLayoutChildren) do
		child:Draw()
	end
end
