-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local ToggleOnOff = TSMAPI_FOUR.Class.DefineClass("ToggleOnOff", TSM.UI.Element)
TSM.UI.ToggleOnOff = ToggleOnOff
local private = { buttonToggleOnOffLookup = {} }



-- ============================================================================
-- Public Class Methods
-- ============================================================================

function ToggleOnOff.__init(self)
	local frame = CreateFrame("Button", nil, nil, nil)
	private.buttonToggleOnOffLookup[frame] = self

	self.__super:__init(frame)

	-- set the click handler
	frame:SetScript("OnClick", private.OnClickHandler)

	-- create the background
	frame.backgroundTexture = frame:CreateTexture(nil, "BACKGROUND")

	self._value = false
	self._disabled = false
	self._settingTable = nil
	self._settingKey = nil
	self._onValueChangedHandler = nil
end

function ToggleOnOff.Release(self)
	self._value = false
	self._disabled = false
	self._settingTable = nil
	self._settingKey = nil
	self._onValueChangedHandler = nil
	self.__super:Release()
end

function ToggleOnOff.SetSettingInfo(self, tbl, key)
	self._settingTable = tbl
	self._settingKey = key
	self._value = tbl[key]
	return self
end

function ToggleOnOff.SetDisabled(self, disabled, redraw)
	self._disabled = disabled
	if disabled then
		self:_GetBaseFrame():Disable()
	else
		self:_GetBaseFrame():Enable()
	end
	if redraw then
		self:Draw()
	end
	return self
end

function ToggleOnOff.SetValue(self, value, redraw)
	if value ~= self._value then
		self._value = value
		if self._settingTable then
			self._settingTable[self._settingKey] = value
		end
		if self._onValueChangedHandler then
			self:_onValueChangedHandler(value)
		end
	end
	if redraw then
		self:Draw()
	end
	return self
end

function ToggleOnOff.SetScript(self, script, handler)
	if script == "OnValueChanged" then
		self._onValueChangedHandler = handler
	else
		error("Unknown ToggleOnOff script: "..tostring(script))
	end
	return self
end

function ToggleOnOff.GetValue(self)
	return self._value
end

function ToggleOnOff.Draw(self)
	self.__super:Draw()
	if self:_GetBaseFrame():IsEnabled() then
		self:SetStyle("backgroundTexturePack", self._value and "uiFrames.ToggleOn" or "uiFrames.ToggleOff")
	else
		self:SetStyle("backgroundTexturePack", self._value and "uiFrames.ToggleDisabledOn" or "uiFrames.ToggleDisabledOff")
	end
	self:_ApplyFrameBackgroundTexture()
end



-- ============================================================================
-- Local Script Handlers
-- ============================================================================

function private.OnClickHandler(button)
	local self = private.buttonToggleOnOffLookup[button]
	self:SetValue(not self._value, true)
end
