-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local Text = TSMAPI_FOUR.Class.DefineClass("Text", TSM.UI.Element)
TSM.UI.Text = Text

function Text.__init(self)
	local frame = CreateFrame("Frame", nil, nil, nil)

	self.__super:__init(frame)

	frame.text = frame:CreateFontString()
	frame.text:SetAllPoints()
end

function Text.Acquire(self)
	self._textStr = ""
	self:_GetBaseFrame():EnableMouse(false)
	self.__super:Acquire()
end

function Text.SetText(self, text)
	self._textStr = text
	return self
end

function Text.SetFormattedText(self, ...)
	self._textStr = format(...)
	return self
end

function Text.GetText(self)
	return self._textStr
end

function Text.GetStringWidth(self)
	local frame = self:_GetBaseFrame()
	self:_ApplyTextStyle(frame.text)
	frame.text:SetText(self._textStr)
	return frame.text:GetStringWidth()
end

function Text.GetStringHeight(self)
	local frame = self:_GetBaseFrame()
	self:_ApplyTextStyle(frame.text)
	frame.text:SetText(self._textStr)
	return frame.text:GetStringHeight()
end

function Text._GetMinimumDimension(self, dimension)
	if dimension == "WIDTH" and self:_GetStyle("autoWidth") then
		return self:GetStringWidth(), nil
	else
		return self.__super:_GetMinimumDimension(dimension)
	end
end

function Text.Draw(self)
	self.__super:Draw()
	local frame = self:_GetBaseFrame()
	self:_ApplyTextStyle(frame.text)

	-- set the text
	frame.text:SetText(self._textStr)

	local spacing = self:_GetStyle("fontSpacing")
	if spacing then
		frame.text:SetSpacing(spacing)
	end
end
