-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local SelectionScrollingTable = TSMAPI_FOUR.Class.DefineClass("SelectionScrollingTable", TSM.UI.FastScrollingTable)
TSM.UI.SelectionScrollingTable = SelectionScrollingTable
local CHECK_LEFT_SPACING = 4
local CHECK_RIGHT_SPACING = 6
local ICON_SPACING = 4



-- ============================================================================
-- SelectionScrollingTable - Public Class Methods
-- ============================================================================

function SelectionScrollingTable.__init(self)
	self.__super:__init()

	self._selectedData = {}
	self._selectionEnabledFunc = nil
end

function SelectionScrollingTable.Release(self)
	wipe(self._selectedData)
	self._selectionEnabledFunc = nil
	self.__super:Release()
end

function SelectionScrollingTable.ClearSelection(self)
	wipe(self._selectedData)
	if self._onSelectionChangedHandler then
		self._onSelectionChangedHandler(self)
	end
end

function SelectionScrollingTable.SetIsSelectionEnabledFunc(self, func)
	self._selectionEnabledFunc = func
	return self
end

function SelectionScrollingTable.SetSelection(self, data)
	if self._selectionEnabledFunc and not self:_selectionEnabledFunc(data) then
		assert(not self._selectedData[data])
		return
	end
	self._selectedData[data] = not self._selectedData[data] or nil
	for _, row in ipairs(self._rows) do
		if row:GetData() == data then
			if self._selectedData[data] then
				row._icons.check:Show()
			else
				row._icons.check:Hide()
			end
			break
		end
	end
	if self._onSelectionChangedHandler then
		self._onSelectionChangedHandler(self)
	end
	return self
end

function SelectionScrollingTable.GetSelection(self)
	return self._selectedData
end



-- ============================================================================
-- SelectionScrollingTable - Private Class Methods
-- ============================================================================

function SelectionScrollingTable._GetTableRow(self, isHeader)
	local row = self.__super:_GetTableRow(isHeader)
	if not isHeader then
		-- add the checkmark texture before the first col
		local id = self._tableInfo:_GetCols()[1]:_GetId()

		local check = row:_GetTexture()
		TSM.UI.TexturePacks.SetTextureAndSize(check, "iconPack.14x14/Checkmark/Default")
		check:SetPoint("LEFT", CHECK_LEFT_SPACING, 0)
		row._icons.check = check

		local icon = row._icons[id]
		icon:ClearAllPoints()
		icon:SetPoint("LEFT", check, "RIGHT", CHECK_RIGHT_SPACING, 0)

		local text = row._texts[id]
		text:SetPoint("LEFT", icon, "RIGHT", ICON_SPACING, 0)
	end
	return row
end

function SelectionScrollingTable._SetRowData(self, row, data)
	if self._selectedData[data] then
		row._icons.check:Show()
	else
		row._icons.check:Hide()
	end
	self.__super:_SetRowData(row, data)
end
