-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local SelectionList = TSMAPI_FOUR.Class.DefineClass("SelectionList", TSM.UI.ScrollList)
TSM.UI.SelectionList = SelectionList
local private = {}



-- ============================================================================
-- Public Class Methods
-- ============================================================================

function SelectionList.__init(self)
	self.__super:__init()
	self._selectedEntry = nil
	self._onEntrySelectedHandler = nil
end

function SelectionList.Release(self)
	self._selectedEntry = nil
	self._onEntrySelectedHandler = nil
	self.__super:Release()
end

function SelectionList.SetEntries(self, entries, selectedEntry)
	wipe(self._data)
	for _, entry in ipairs(entries) do
		tinsert(self._data, entry)
	end
	self._selectedEntry = selectedEntry
	return self
end

function SelectionList.SetScript(self, script, handler)
	if script == "OnEntrySelected" then
		self._onEntrySelectedHandler = handler
	else
		error("Unknown SelectionList script: "..tostring(script))
	end
	return self
end



-- ============================================================================
-- Private Class Methods
-- ============================================================================

function SelectionList._CreateRow(self)
	return self.__super:_CreateRow()
		:AddChildNoLayout(TSMAPI_FOUR.UI.NewElement("Button", "button")
			:SetStyle("anchors", { { "TOPLEFT" }, { "BOTTOMRIGHT" } })
			:SetScript("OnClick", private.RowOnClick)
		)
		:AddChildNoLayout(TSMAPI_FOUR.UI.NewElement("Text", "text")
			:SetStyle("fontHeight", 12)
			:SetStyle("textColor", "#e2e2e2")
			:SetStyle("anchors", { { "TOPLEFT", 8, 0 }, { "BOTTOMRIGHT", -8, 0 } })
		)
end

function SelectionList._SetRowHitRectInsets(self, row, top, bottom)
	row:GetElement("button"):SetHitRectInsets(0, 0, top, bottom)
	self.__super:_SetRowHitRectInsets(row, top, bottom)
end

function SelectionList._DrawRow(self, row, dataIndex)
	local operationName = row:GetContext()
	local isSelected = operationName == self._selectedEntry

	row:GetElement("text")
		:SetStyle("textColor", isSelected and "#ffd839" or "#e2e2e2")
		:SetStyle("font", isSelected and TSM.UI.Fonts.bold or TSM.UI.Fonts.regular)
		:SetText(operationName)

	self.__super:_DrawRow(row, dataIndex)
end



-- ============================================================================
-- Local Script Handlers
-- ============================================================================

function private.RowOnClick(button)
	local row = button:GetParentElement()
	local self = row:GetParentElement()
	if self._onEntrySelectedHandler then
		self:_onEntrySelectedHandler(row:GetContext())
	end
end
