-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local L = LibStub("AceLocale-3.0"):GetLocale("TradeSkillMaster") -- loads the localization table
local SelectionGroupTree = TSMAPI_FOUR.Class.DefineClass("SelectionGroupTree", TSM.UI.GroupTree)
TSM.UI.SelectionGroupTree = SelectionGroupTree
local private = {}



-- ============================================================================
-- Public Class Methods
-- ============================================================================

function SelectionGroupTree.__init(self)
	self.__super:__init()

	self._selectedGroup = TSM.CONST.ROOT_GROUP_PATH
	self._selectedGroupChangedHandler = nil
end

function SelectionGroupTree.Release(self)
	self._selectedGroupChangedHandler = nil
	self._selectedGroup = TSM.CONST.ROOT_GROUP_PATH
	self.__super:Release()
end

function SelectionGroupTree.SetScript(self, script, handler)
	if script == "OnGroupSelectionChanged" then
		self._selectedGroupChangedHandler = handler
	else
		error("Unknown SelectionGroupTree script: "..tostring(script))
	end
	return self
end



-- ============================================================================
-- Private Class Methods
-- ============================================================================

function SelectionGroupTree._HandleRowClick(self, data)
	self._selectedGroup = data
	self:Draw()
	if self._selectedGroupChangedHandler then
		self:_selectedGroupChangedHandler(data)
	end
end

function SelectionGroupTree._IsSelected(self, data)
	return data == self._selectedGroup
end
