-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local SecureMacroActionButton = TSMAPI_FOUR.Class.DefineClass("SecureMacroActionButton", TSM.UI.ActionButton)
TSM.UI.SecureMacroActionButton = SecureMacroActionButton
local private = { frameButtonLookup = {} }



-- ============================================================================
-- Public Class Methods
-- ============================================================================

function SecureMacroActionButton.__init(self, name)
	self.__super:__init(name, true)
	self:_GetBaseFrame():SetAttribute("type1", "macro")
	self:_GetBaseFrame():SetAttribute("macrotext1", "")
end

function SecureMacroActionButton.Release(self)
	self:_GetBaseFrame():SetScript("PreClick", nil)
	self:_GetBaseFrame():SetAttribute("macrotext1", "")
	self.__super:Release()
end

function SecureMacroActionButton.SetScript(self, script, handler)
	if script == "PreClick" then
		self:_GetBaseFrame():SetScript(script, handler)
	else
		error("Unknown SecureActionButton script: "..tostring(script))
	end
	return self
end

function SecureMacroActionButton.SetMacroText(self, text)
	self:_GetBaseFrame():SetAttribute("macrotext1", text)
	return self
end
