-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local private = { frameInputLookup = {} }
local InputNumeric = TSMAPI_FOUR.Class.DefineClass("InputNumeric", TSM.UI.Input)
TSM.UI.InputNumeric = InputNumeric



-- ============================================================================
-- Public Class Methods
-- ============================================================================

function InputNumeric.__init(self)
	self.__super:__init()
	self._maxNumber = nil

	local frame = self:_GetBaseFrame()
	frame:SetNumeric(true)
	frame:SetScript("OnEnterPressed", private.OnEnterPressed)

	private.frameInputLookup[frame] = self
end

function InputNumeric.Release(self)
	self._maxNumber = nil
	self.__super:Release()
end

function InputNumeric.GetNumber(self)
	return self:_GetBaseFrame():GetNumber()
end

function InputNumeric.SetMaxNumber(self, maxNumber)
	self._maxNumber = maxNumber
	return self
end



-- ============================================================================
-- Local Script Handlers
-- ============================================================================

function private.OnEnterPressed(frame)
	frame:HighlightText(0, 0)
	local self = private.frameInputLookup[frame]

	if self._settingTable and self._settingKey then
		local value = self:GetNumber()

		if self._validation and self._validation(value) or not self._validation then
			value = private.CheckMaxNumber(frame, value)
			self._settingTable[self._settingKey] = value
			self:SetText(value)
		end

		self:Draw()
	end

	frame:ClearFocus()
	
	if self._userScriptHandlers.OnEnterPressed then
		self._userScriptHandlers.OnEnterPressed(self)
	end
end

function private.CheckMaxNumber(frame, value)
	local self = private.frameInputLookup[frame]

	if self._maxNumber and value > self._maxNumber then
		return self._maxNumber
	else
		return value
	end
end
