-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local Checkbox = TSMAPI_FOUR.Class.DefineClass("Checkbox", TSM.UI.Element)
TSM.UI.Checkbox = Checkbox
local private = { checkboxLookup = {} }



-- ============================================================================
-- Public Class Methods
-- ============================================================================

function Checkbox.__init(self)
	local frame = CreateFrame("Button", nil, nil, nil)

	self.__super:__init(frame)

	frame:SetScript("OnClick", private.FrameOnClick)
	private.checkboxLookup[frame] = self

	-- create the text and check texture
	frame.text = frame:CreateFontString()
	frame.text:SetJustifyV("MIDDLE")
	frame.check = frame:CreateTexture()

	self._textStr = ""
	self._position = "LEFT"
	self._value = false
	self._onValueChangedHandler = nil
	self._settingTable = nil
	self._settingKey = nil
end

function Checkbox.Acquire(self)
	self._textStr = ""
	self._position = "LEFT"
	self._value = false
	self.__super:Acquire()
end

function Checkbox.Release(self)
	self._onValueChangedHandler = nil
	self._settingTable = nil
	self._settingKey = nil
	self.__super:Release()
end

function Checkbox.SetCheckboxPosition(self, position)
	if position == "LEFT" or position == "RIGHT" then
		self._position = position
	else
		error("Invalid checkbox position: "..tostring(position))
	end
	return self
end

function Checkbox.SetText(self, text)
	self._textStr = text
	return self
end

function Checkbox.GetText(self)
	return self._textStr
end

function Checkbox.SetFormattedText(self, ...)
	self._textStr = format(...)
	return self
end

function Checkbox.SetChecked(self, value)
	self._value = value
	if self._onValueChangedHandler then
		self:_onValueChangedHandler(value)
	end
	return self
end

function Checkbox.SetSettingInfo(self, tbl, key, validation)
	self._settingTable = tbl
	self._settingKey = key

	self._value = tbl[key]

	self:SetChecked(self._value)
	return self
end

function Checkbox.IsChecked(self)
	return self._value
end

function Checkbox.SetScript(self, script, handler)
	if script == "OnValueChanged" then
		self._onValueChangedHandler = handler
	else
		error("Unknown Checkbox script: "..tostring(script))
	end
	return self
end

function Checkbox.Draw(self)
	self.__super:Draw()
	local frame = self:_GetBaseFrame()
	self:_ApplyFrameStyle(frame)
	self:_ApplyTextStyle(frame.text)

	frame.text:SetText(self._textStr)
	TSM.UI.TexturePacks.SetTextureAndSize(frame.check, self:_GetStyle(self._value and "checkedTexturePack" or "uncheckedTexturePack"))

	frame.text:ClearAllPoints()
	frame.check:ClearAllPoints()
	if self._position == "LEFT" then
		frame.check:SetPoint("LEFT")
		frame.text:SetJustifyH("LEFT")
		frame.text:SetPoint("LEFT", frame.check, "RIGHT", self:_GetStyle("checkboxSpacing"), 0)
		frame.text:SetPoint("TOPRIGHT")
		frame.text:SetPoint("BOTTOMRIGHT")
	elseif self._position == "RIGHT" then
		frame.check:SetPoint("RIGHT")
		frame.text:SetJustifyH("RIGHT")
		frame.text:SetPoint("BOTTOMLEFT")
		frame.text:SetPoint("TOPLEFT")
		frame.text:SetPoint("RIGHT", frame.check, "LEFT", -self:_GetStyle("checkboxSpacing"), 0)
	else
		error("Invalid position: "..tostring(self._position))
	end
end



-- ============================================================================
-- Local Script Handlers
-- ============================================================================

function private.FrameOnClick(frame)
	local self = private.checkboxLookup[frame]
	local value = not self._value

	if self._settingTable and self._settingKey then
		self._settingTable[self._settingKey] = value
	end

	self:SetChecked(value)
	self:Draw()
end
