-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local Button = TSMAPI_FOUR.Class.DefineClass("Button", TSM.UI.Element)
TSM.UI.Button = Button
local ICON_PADDING = 2



function Button.__init(self, name)
	local frame = CreateFrame("Button", name, nil, nil)

	self.__super:__init(frame)

	frame.backgroundTexture = frame:CreateTexture(nil, "BACKGROUND")

	-- create the highlight
	frame.highlight = frame:CreateTexture(nil, "HIGHLIGHT")
	frame.highlight:SetAllPoints()
	frame.highlight:SetBlendMode("BLEND")
	frame:SetHighlightTexture(self.highlight)

	-- create the text
	frame.text = frame:CreateFontString()

	-- create the icon
	frame.icon = frame:CreateTexture(nil, "ARTWORK")
	frame.icon:SetPoint("RIGHT", frame.text, "LEFT", -ICON_PADDING, 0)

	self._textStr = ""
end

function Button.Acquire(self)
	self._textStr = ""
	self:_GetBaseFrame():Enable()
	self:_GetBaseFrame():RegisterForClicks("LeftButtonUp")
	self:_GetBaseFrame():SetHitRectInsets(0, 0, 0, 0)
	self.__super:Acquire()
end

function Button.SetText(self, text)
	self._textStr = text
	return self
end

function Button.SetFormattedText(self, ...)
	self._textStr = format(...)
	return self
end

function Button.SetDisabled(self, disabled)
	if disabled then
		self:_GetBaseFrame():Disable()
	else
		self:_GetBaseFrame():Enable()
	end
	return self
end

function Button.RegisterForDrag(self, button)
	self:_GetBaseFrame():RegisterForDrag(button)
	return self
end

function Button.GetText(self)
	return self._textStr
end

function Button.ShowText(self)
	self:_GetBaseFrame().text:Show()
end

function Button.HideText(self)
	self:_GetBaseFrame().text:Hide()
end

function Button.GetStringWidth(self)
	local text = self:_GetBaseFrame().text
	self:_ApplyTextStyle(text)
	text:SetText(self._textStr)
	return text:GetStringWidth()
end

function Button.Click(self)
	self:_GetBaseFrame():Click()
end

function Button.EnableRightClick(self)
	self:_GetBaseFrame():RegisterForClicks("LeftButtonUp", "RightButtonUp")
	return self
end

function Button.SetHitRectInsets(self, left, right, top, bottom)
	self:_GetBaseFrame():SetHitRectInsets(left, right, top, bottom)
	return self
end

function Button._GetMinimumDimension(self, dimension)
	if dimension == "WIDTH" and self:_GetStyle("autoWidth") then
		return self:GetStringWidth(), nil
	else
		return self.__super:_GetMinimumDimension(dimension)
	end
end

function Button.Draw(self)
	self.__super:Draw()
	self:_ApplyFrameBackgroundTexture()
	local frame = self:_GetBaseFrame()
	self:_ApplyTextStyle(frame.text)

	-- set the text color
	local textColor = self:_GetStyle(frame:IsEnabled() and "textColor" or "disabledTextColor")
	frame.text:SetTextColor(TSM.UI.HexToRGBA(textColor))

	-- set the text
	frame.text:SetText(self._textStr)

	-- set the highlight texture
	local highlight = self:_GetStyle("highlight")
	if highlight then
		frame.highlight:SetColorTexture(TSM.UI.HexToRGBA(highlight))
	end

	local iconTexturePack = self:_GetStyle("iconTexturePack")
	if iconTexturePack then
		local iconSize = self:_GetStyle("iconSize")
		if iconSize then
			frame.icon:SetWidth(iconSize)
			frame.icon:SetHeight(iconSize)
			TSM.UI.TexturePacks.SetTexture(frame.icon, iconTexturePack)
		else
			TSM.UI.TexturePacks.SetTextureAndSize(frame.icon, iconTexturePack)
		end
		frame.icon:Show()
		frame.icon:SetVertexColor(TSM.UI.HexToRGBA(textColor))
		local xOffset = ((iconSize or TSM.UI.TexturePacks.GetWidth(iconTexturePack)) + ICON_PADDING) / 2
		frame.text:ClearAllPoints()
		frame.text:SetPoint("TOP", xOffset, 0)
		frame.text:SetPoint("BOTTOM", xOffset, 0)
		frame.text:SetWidth(frame.text:GetStringWidth())
	else
		frame.icon:Hide()
		frame.text:ClearAllPoints()
		frame.text:SetPoint("TOPLEFT", self:_GetStyle("textIndent") or 0, 0)
		frame.text:SetPoint("BOTTOMRIGHT")
	end
end
