-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local AlphaAnimatedFrame = TSMAPI_FOUR.Class.DefineClass("AlphaAnimatedFrame", TSM.UI.Frame)
TSM.UI.AlphaAnimatedFrame = AlphaAnimatedFrame



-- ============================================================================
-- Public Class Methods
-- ============================================================================

function AlphaAnimatedFrame.__init(self)
	self.__super:__init()

	local frame = self:_GetBaseFrame()
	self._ag = frame:CreateAnimationGroup()
	self._ag:SetLooping("BOUNCE")
	self._alpha = self._ag:CreateAnimation("Alpha")
end

function AlphaAnimatedFrame.Acquire(self)
	self._alpha:SetFromAlpha(1)
	self._alpha:SetToAlpha(1)
	self._alpha:SetDuration(1)
	self.__super:Acquire()
end

function AlphaAnimatedFrame.Release(self)
	self._ag:Stop()
	self.__super:Release()
end

function AlphaAnimatedFrame.SetRange(self, fromAlpha, toAlpha)
	self._alpha:SetFromAlpha(fromAlpha)
	self._alpha:SetToAlpha(toAlpha)
	return self
end

function AlphaAnimatedFrame.SetDuration(self, duration)
	self._alpha:SetDuration(duration)
	return self
end

function AlphaAnimatedFrame.SetPlaying(self, playing)
	if playing then
		self._ag:Play()
	else
		self._ag:Stop()
	end
	return self
end

function AlphaAnimatedFrame.IsPlaying(self)
	return self._ag:IsPlaying()
end
