-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                http://www.curse.com/addons/wow/tradeskill-master               --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --

local _, TSM = ...
local ActionButton = TSMAPI_FOUR.Class.DefineClass("ActionButton", TSM.UI.Element)
TSM.UI.ActionButton = ActionButton
local private = { frameButtonLookup = {} }



-- ============================================================================
-- Public Class Methods
-- ============================================================================

function ActionButton.__init(self, name, isSecure)
	local frame = CreateFrame("Button", name, nil, isSecure and "SecureActionButtonTemplate" or nil)
	frame:SetScript(isSecure and "PostClick" or "OnClick", private.OnClick)
	private.frameButtonLookup[frame] = self

	self.__super:__init(frame)

	frame.bgLeft = frame:CreateTexture(nil, "BACKGROUND")
	frame.bgLeft:SetPoint("TOPLEFT")
	frame.bgLeft:SetPoint("BOTTOMLEFT")

	frame.bgRight = frame:CreateTexture(nil, "BACKGROUND")
	frame.bgRight:SetPoint("TOPRIGHT")
	frame.bgRight:SetPoint("BOTTOMRIGHT")

	frame.bgMiddle = frame:CreateTexture(nil, "BACKGROUND")
	frame.bgMiddle:SetPoint("TOPLEFT", frame.bgLeft, "TOPRIGHT")
	frame.bgMiddle:SetPoint("BOTTOMRIGHT", frame.bgRight, "BOTTOMLEFT")

	-- create the text
	frame.text = frame:CreateFontString()
	frame.text:SetAllPoints()

	self._pressed = false
	self._disabled = false
	self._textStr = ""
	self._onClickHandler = nil
end

function ActionButton.Acquire(self)
	self._pressed = false
	self._disabled = false
	self._textStr = ""
	self:_GetBaseFrame():Enable()
	self:_GetBaseFrame():RegisterForClicks("LeftButtonUp")
	self.__super:Acquire()
end

function ActionButton.Release(self)
	self._onClickHandler = nil
	self.__super:Release()
end

function ActionButton.SetScript(self, script, handler)
	if script == "OnClick" then
		self._onClickHandler = handler
	else
		error("Unknown ActionButton script: "..tostring(script))
	end
	return self
end

function ActionButton.SetText(self, text)
	self._textStr = text
	return self
end

function ActionButton.SetDisabled(self, disabled)
	self._disabled = disabled
	self:_UpdateDisabled()
	return self
end

function ActionButton.SetPressed(self, pressed)
	self._pressed = pressed
	self:_UpdateDisabled()
	return self
end

function ActionButton.Click(self)
	self:_GetBaseFrame():Click()
end



-- ============================================================================
-- Private Class Methods
-- ============================================================================

function ActionButton._UpdateDisabled(self)
	local frame = self:_GetBaseFrame()
	if self._disabled or self._pressed then
		frame:Disable()
	else
		frame:Enable()
	end
end

function ActionButton.Draw(self)
	self.__super:Draw()

	local frame = self:_GetBaseFrame()
	self:_ApplyFrameStyle(frame)
	self:_ApplyTextStyle(frame.text)
	frame.text:SetText(self._textStr)

	local height = TSMAPI_FOUR.Util.Round(self:_GetDimension("HEIGHT"))
	local size = nil
	if height == 15 then
		size = "Small"
	elseif height == 20 then
		size = "Medium"
	elseif height == 26 then
		size = "Large"
	else
		error("Invalid ActionButton height: "..tostring(height))
	end

	-- set textures and text color depending on the state
	if self._pressed then
		frame.text:SetTextColor(TSM.UI.HexToRGBA(self:_GetStyle("pressedTextColor")))
		TSM.UI.TexturePacks.SetTextureAndWidth(frame.bgLeft, "uiFrames."..size.."ClickedButtonLeft")
		TSM.UI.TexturePacks.SetTexture(frame.bgMiddle, "uiFrames."..size.."ClickedButtonMiddle")
		TSM.UI.TexturePacks.SetTextureAndWidth(frame.bgRight, "uiFrames."..size.."ClickedButtonRight")
	elseif self._disabled then
		frame.text:SetTextColor(TSM.UI.HexToRGBA(self:_GetStyle("inactiveTextColor")))
		TSM.UI.TexturePacks.SetTextureAndWidth(frame.bgLeft, "uiFrames."..size.."InactiveButtonLeft")
		TSM.UI.TexturePacks.SetTexture(frame.bgMiddle, "uiFrames."..size.."InactiveButtonMiddle")
		TSM.UI.TexturePacks.SetTextureAndWidth(frame.bgRight, "uiFrames."..size.."InactiveButtonRight")
	else
		frame.text:SetTextColor(TSM.UI.HexToRGBA(self:_GetStyle("textColor")))
		TSM.UI.TexturePacks.SetTextureAndWidth(frame.bgLeft, "uiFrames."..size.."ActiveButtonLeft")
		TSM.UI.TexturePacks.SetTexture(frame.bgMiddle, "uiFrames."..size.."ActiveButtonMiddle")
		TSM.UI.TexturePacks.SetTextureAndWidth(frame.bgRight, "uiFrames."..size.."ActiveButtonRight")
	end

	local text = self:_GetBaseFrame().text
	text:ClearAllPoints()
	text:SetPoint("TOPLEFT", self:_GetStyle("textIndent") or 0, 0)
	text:SetPoint("BOTTOMRIGHT")
end



-- ============================================================================
-- Local Script Handlers
-- ============================================================================

function private.OnClick(frame)
	local self = private.frameButtonLookup[frame]
	self:SetPressed(true)
	self:Draw()
	if self._onClickHandler then
		self:_onClickHandler()
	end
end
