-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--          http://www.curse.com/addons/wow/tradeskillmaster_warehousing          --
--                                                                                --
--             A TradeSkillMaster Addon (http://tradeskillmaster.com)             --
--    All Rights Reserved* - Detailed license information included with addon.    --
-- ------------------------------------------------------------------------------ --


TSMAPI_FOUR.PlayerInfo = {}
local _, TSM = ...
local PLAYER_LOWER = strlower(UnitName("player"))
local FACTION_LOWER = strlower(UnitFactionGroup("player"))
local REALM_LOWER = strlower(GetRealmName())
local PLAYER_REALM_LOWER = PLAYER_LOWER.." - "..REALM_LOWER



-- ============================================================================
-- TSMAPI Functions
-- ============================================================================

function TSMAPI_FOUR.PlayerInfo.GetCharacters(currentAccountOnly)
	local characters = {}
	if currentAccountOnly then
		for _, name in TSM.db:FactionrealmCharacterByAccountIterator() do
			characters[name] = true
		end
	else
		for _, name in TSM.db:FactionrealmCharacterIterator() do
			characters[name] = true
		end
	end
	return characters
end

function TSMAPI_FOUR.PlayerInfo.GetGuilds(includeIgnored)
	local guilds = {}
	for name in pairs(TSM.db.factionrealm.internalData.guildVaults) do
		if includeIgnored or not TSM.db.factionrealm.coreOptions.ignoreGuilds[name] then
			guilds[name] = true
		end
	end
	return guilds
end

function TSMAPI_FOUR.PlayerInfo.GetPlayerGuild(player)
	return player and TSM.db.factionrealm.internalData.characterGuilds[player] or nil
end

function TSMAPI_FOUR.PlayerInfo.IsPlayer(target, includeAlts, includeOtherFaction, includeOtherAccounts)
	target = strlower(target)
	if not strfind(target, " %- ") then
		target = gsub(target, "%-", " - ", 1)
	end
	if target == PLAYER_LOWER then
		return true
	elseif strfind(target, " %- ") and target == PLAYER_REALM_LOWER then
		return true
	end
	if not strfind(target, " %- ") then
		target = target.." - "..REALM_LOWER
	end
	if includeAlts then
		for factionrealm in TSM.db:GetConnectedRealmIterator("factionrealm") do
			local factionKey, realmKey = strmatch(factionrealm, "(.+) %- (.+)")
			factionKey = strlower(factionKey)
			realmKey = strlower(realmKey)
			if includeOtherFaction or factionKey == FACTION_LOWER then
				local found = false
				if includeOtherAccounts then
					for _, charKey in TSM.db:FactionrealmCharacterIterator(factionrealm) do
						if target == (strlower(charKey).." - "..realmKey) then
							found = true
						end
					end
				else
					for _, charKey in TSM.db:FactionrealmCharacterByAccountIterator(nil, factionrealm) do
						if target == (strlower(charKey).." - "..realmKey) then
							found = true
						end
					end
				end
				if found then
					return true
				end
			end
		end
	end
end
